/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.ForwardHttpRequestBuilder;
import com.github.kristofa.test.http.HttpRequestResponseLoggerFactory;
import com.github.kristofa.test.http.HttpResponseProvider;
import com.github.kristofa.test.http.LoggingHttpProxy;
import com.github.kristofa.test.http.MockHttpServer;
import com.github.kristofa.test.http.UnsatisfiedExpectationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.Validate;

public class MockAndProxyFacade {
    private final Mode mode;
    private MockHttpServer mockServer;
    private LoggingHttpProxy proxy;

    private MockAndProxyFacade(Builder builder) {
        Validate.notNull((Object)((Object)builder.mode), (String)"You should have set mode in builder!", (Object[])new Object[0]);
        this.mode = builder.mode;
        Validate.isTrue((builder.port > 0 ? 1 : 0) != 0, (String)"You should have set port in builder!", (Object[])new Object[0]);
        if (Mode.MOCKING.equals((Object)this.mode)) {
            Validate.notNull((Object)builder.responseProvider, (String)"You should have set a HttpResponseProvider in builder when using Mocking mode!", (Object[])new Object[0]);
            this.mockServer = new MockHttpServer(builder.port, builder.responseProvider);
        } else {
            Validate.notNull((Object)builder.requestBuilders, (String)"You should have added a ForwardHttpRequestBuilder when using Logging mode!", (Object[])new Object[0]);
            Validate.notNull((Object)builder.loggerFactory, (String)"You should have set a HttpRequestResponseLoggerFactory when using Logging mode!", (Object[])new Object[0]);
            this.proxy = new LoggingHttpProxy(builder.port, builder.requestBuilders, builder.loggerFactory);
        }
    }

    public void start() throws IOException {
        if (Mode.MOCKING.equals((Object)this.mode)) {
            this.mockServer.start();
        } else {
            this.proxy.start();
        }
    }

    public void stop() throws IOException {
        if (Mode.MOCKING.equals((Object)this.mode)) {
            this.mockServer.stop();
        } else {
            this.proxy.stop();
        }
    }

    public void verify() throws UnsatisfiedExpectationException {
        if (Mode.MOCKING.equals((Object)this.mode)) {
            this.mockServer.verify();
        }
    }

    public static class Builder {
        private static final int MINPORT = 1;
        private static final int MAXPORT = 65535;
        private int port;
        private HttpResponseProvider responseProvider;
        private final Collection<ForwardHttpRequestBuilder> requestBuilders = new ArrayList<ForwardHttpRequestBuilder>();
        private HttpRequestResponseLoggerFactory loggerFactory;
        private Mode mode;

        public Builder port(int port) {
            Validate.inclusiveBetween((Object)1, (Object)65535, (Comparable)Integer.valueOf(port));
            this.port = port;
            return this;
        }

        public Builder httpResponseProvider(HttpResponseProvider responseProvider) {
            Validate.notNull((Object)responseProvider);
            this.responseProvider = responseProvider;
            return this;
        }

        public Builder addForwardHttpRequestBuilder(ForwardHttpRequestBuilder requestBuilder) {
            Validate.notNull((Object)requestBuilder);
            this.requestBuilders.add(requestBuilder);
            return this;
        }

        public Builder httpRequestResponseLoggerFactory(HttpRequestResponseLoggerFactory loggerFactory) {
            Validate.notNull((Object)loggerFactory);
            this.loggerFactory = loggerFactory;
            return this;
        }

        public Builder mode(Mode mode) {
            Validate.notNull((Object)((Object)mode));
            this.mode = mode;
            return this;
        }

        public MockAndProxyFacade build() {
            return new MockAndProxyFacade(this);
        }
    }

    public static enum Mode {
        MOCKING,
        LOGGING;

    }
}

