/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http;

import com.github.kristofa.test.http.AbstractHttpResponseProvider;
import com.github.kristofa.test.http.AllExceptContentTypeHeaderFilter;
import com.github.kristofa.test.http.DefaultHttpResponseProxy;
import com.github.kristofa.test.http.HttpRequestImpl;
import com.github.kristofa.test.http.HttpResponseImpl;
import com.github.kristofa.test.http.Method;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class SimpleHttpResponseProvider
extends AbstractHttpResponseProvider {
    private static final String CONTENT_TYPE_HTTP_HEADER_NAME = "Content-Type";
    private HttpRequestImpl latestRequest;

    public SimpleHttpResponseProvider() {
        this.addHttpRequestMatchingFilter(new AllExceptContentTypeHeaderFilter());
    }

    public SimpleHttpResponseProvider expect(Method method, String path, String contentType, String requestEntity) {
        this.latestRequest = new HttpRequestImpl();
        this.latestRequest.method(method).content(requestEntity.getBytes()).httpMessageHeader(CONTENT_TYPE_HTTP_HEADER_NAME, contentType);
        this.extractAndSetQueryParams(this.latestRequest, path);
        return this;
    }

    public SimpleHttpResponseProvider expect(Method method, String path) {
        this.latestRequest = new HttpRequestImpl();
        this.latestRequest.method(method);
        this.extractAndSetQueryParams(this.latestRequest, path);
        return this;
    }

    public SimpleHttpResponseProvider respondWith(int httpCode, String contentType, String requestEntity) {
        HttpResponseImpl response = new HttpResponseImpl(httpCode, contentType, requestEntity == null ? null : requestEntity.getBytes());
        this.addExpected(this.latestRequest, new DefaultHttpResponseProxy(response));
        return this;
    }

    public void reset() {
        this.resetState();
    }

    private void extractAndSetQueryParams(HttpRequestImpl request, String path) {
        int indexOfQuestionMark = path.indexOf("?");
        if (indexOfQuestionMark >= 0) {
            String newPath = path.substring(0, indexOfQuestionMark);
            String queryParams = path.substring(indexOfQuestionMark + 1);
            List parameters = URLEncodedUtils.parse((String)queryParams, (Charset)Charset.forName("UTF-8"));
            for (NameValuePair parameter : parameters) {
                request.queryParameter(parameter.getName(), parameter.getValue());
            }
            request.path(newPath);
        } else {
            request.path(path);
        }
    }
}

