/*
 * Decompiled with CFR 0.152.
 */
package com.github.kristofa.test.http.file;

import com.github.kristofa.test.http.HttpResponse;
import com.github.kristofa.test.http.HttpResponseProxy;
import com.github.kristofa.test.http.file.FileNameBuilder;
import com.github.kristofa.test.http.file.HttpResponseFileReader;
import java.io.File;

class FileHttpResponseProxy
implements HttpResponseProxy {
    private final String directory;
    private final String filename;
    private final int seqNr;
    private boolean isConsumed = false;
    private final HttpResponseFileReader httpResponseFileReader;

    public FileHttpResponseProxy(String directory, String filename, int seqNr, HttpResponseFileReader responseFileReader) {
        this.directory = directory;
        this.filename = filename;
        this.seqNr = seqNr;
        this.httpResponseFileReader = responseFileReader;
    }

    @Override
    public boolean consumed() {
        return this.isConsumed;
    }

    @Override
    public HttpResponse getResponse() {
        return this.readResponse();
    }

    @Override
    public HttpResponse consume() {
        HttpResponse response = this.readResponse();
        this.isConsumed = true;
        return response;
    }

    private HttpResponse readResponse() {
        File responseFile = new File(this.directory, FileNameBuilder.RESPONSE_FILE_NAME.getFileName(this.filename, this.seqNr));
        File responseEntityFile = new File(this.directory, FileNameBuilder.RESPONSE_ENTITY_FILE_NAME.getFileName(this.filename, this.seqNr));
        HttpResponse response = this.httpResponseFileReader.read(responseFile, responseEntityFile);
        return response;
    }
}

