/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksoichiro.android.observablescrollview;

import android.content.Context;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import com.github.ksoichiro.android.observablescrollview.internal.LogUtils;

public class ObservableListView
extends ListView {
    private static final String TAG = ObservableListView.class.getSimpleName();
    private ObservableScrollViewCallbacks mCallbacks;
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private SparseIntArray mChildrenHeights;
    private int mPrevScrollY;
    private int mScrollY;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;

    public ObservableListView(Context context) {
        super(context);
        this.init();
    }

    public ObservableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ObservableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int i = this.getFirstVisiblePosition();
            int j = 0;
            while (i <= this.getLastVisiblePosition()) {
                if (this.mChildrenHeights.indexOfKey(i) < 0 || this.getChildAt(j).getHeight() != this.mChildrenHeights.get(i)) {
                    this.mChildrenHeights.put(i, this.getChildAt(j).getHeight());
                }
                ++i;
                ++j;
            }
            View firstVisibleChild = this.getChildAt(0);
            if (firstVisibleChild != null) {
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        LogUtils.v(TAG, "Skipped some children while scrolling down: " + (firstVisiblePosition - this.mPrevFirstVisiblePosition));
                        for (int i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 < this.mChildrenHeights.indexOfKey(i2)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i2);
                                LogUtils.v(TAG, "Calculate skipped child height at " + i2 + ": " + this.mChildrenHeights.get(i2));
                                continue;
                            }
                            LogUtils.v(TAG, "Could not calculate skipped child height at " + i2);
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        LogUtils.v(TAG, "Skipped some children while scrolling up: " + (this.mPrevFirstVisiblePosition - firstVisiblePosition));
                        for (int i3 = this.mPrevFirstVisiblePosition - 1; i3 > firstVisiblePosition; --i3) {
                            if (0 < this.mChildrenHeights.indexOfKey(i3)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i3);
                                LogUtils.v(TAG, "Calculate skipped child height at " + i3 + ": " + this.mChildrenHeights.get(i3));
                                continue;
                            }
                            LogUtils.v(TAG, "Could not calculate skipped child height at " + i3);
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                LogUtils.v(TAG, "first: " + firstVisiblePosition + " scrollY: " + this.mScrollY + " first height: " + firstVisibleChild.getHeight() + " first top: " + firstVisibleChild.getTop());
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mScrollState = this.mPrevScrollY < this.mScrollY ? ScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ScrollState.DOWN : ScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            } else {
                LogUtils.v(TAG, "first: " + firstVisiblePosition);
            }
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                    break;
                }
                case 1: 
                case 3: {
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mScrollState);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    private void init() {
        this.mChildrenHeights = new SparseIntArray();
    }
}

