/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksoichiro.android.observablescrollview;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import com.github.ksoichiro.android.observablescrollview.Scrollable;
import com.github.ksoichiro.android.observablescrollview.internal.LogUtils;

public class ObservableListView
extends ListView
implements Scrollable {
    private static final String TAG = ObservableListView.class.getSimpleName();
    private ObservableScrollViewCallbacks mCallbacks;
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private SparseIntArray mChildrenHeights;
    private int mPrevScrollY;
    private int mScrollY;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;
    private AbsListView.OnScrollListener mOriginalScrollListener;
    private AbsListView.OnScrollListener mScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (ObservableListView.this.mOriginalScrollListener != null) {
                ObservableListView.this.mOriginalScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (ObservableListView.this.mOriginalScrollListener != null) {
                ObservableListView.this.mOriginalScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            ObservableListView.this.onScrollChanged();
        }
    };

    public ObservableListView(Context context) {
        super(context);
        this.init();
    }

    public ObservableListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ObservableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mScrollState);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOriginalScrollListener = l;
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    @Override
    public void scrollVerticallyTo(int y) {
        View firstVisibleChild = this.getChildAt(0);
        if (firstVisibleChild != null) {
            int baseHeight = firstVisibleChild.getHeight();
            int position = y / baseHeight;
            this.setSelection(position);
        }
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    private void init() {
        this.mChildrenHeights = new SparseIntArray();
        super.setOnScrollListener(this.mScrollListener);
    }

    private void onScrollChanged() {
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int i = this.getFirstVisiblePosition();
            int j = 0;
            while (i <= this.getLastVisiblePosition()) {
                if (this.mChildrenHeights.indexOfKey(i) < 0 || this.getChildAt(j).getHeight() != this.mChildrenHeights.get(i)) {
                    this.mChildrenHeights.put(i, this.getChildAt(j).getHeight());
                }
                ++i;
                ++j;
            }
            View firstVisibleChild = this.getChildAt(0);
            if (firstVisibleChild != null) {
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        LogUtils.v(TAG, "Skipped some children while scrolling down: " + (firstVisiblePosition - this.mPrevFirstVisiblePosition));
                        for (int i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 < this.mChildrenHeights.indexOfKey(i2)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i2);
                                LogUtils.v(TAG, "Calculate skipped child height at " + i2 + ": " + this.mChildrenHeights.get(i2));
                                continue;
                            }
                            LogUtils.v(TAG, "Could not calculate skipped child height at " + i2);
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        LogUtils.v(TAG, "Skipped some children while scrolling up: " + (this.mPrevFirstVisiblePosition - firstVisiblePosition));
                        for (int i3 = this.mPrevFirstVisiblePosition - 1; i3 > firstVisiblePosition; --i3) {
                            if (0 < this.mChildrenHeights.indexOfKey(i3)) {
                                skippedChildrenHeight += this.mChildrenHeights.get(i3);
                                LogUtils.v(TAG, "Calculate skipped child height at " + i3 + ": " + this.mChildrenHeights.get(i3));
                                continue;
                            }
                            LogUtils.v(TAG, "Could not calculate skipped child height at " + i3);
                            skippedChildrenHeight += firstVisibleChild.getHeight();
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                LogUtils.v(TAG, "first: " + firstVisiblePosition + " scrollY: " + this.mScrollY + " first height: " + firstVisibleChild.getHeight() + " first top: " + firstVisibleChild.getTop());
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mScrollState = this.mPrevScrollY < this.mScrollY ? ScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ScrollState.DOWN : ScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            } else {
                LogUtils.v(TAG, "first: " + firstVisiblePosition);
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int prevFirstVisiblePosition;
        int prevFirstVisibleChildHeight = -1;
        int prevScrolledChildrenHeight;
        int prevScrollY;
        int scrollY;
        SparseIntArray childrenHeights;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.prevFirstVisiblePosition = in.readInt();
            this.prevFirstVisibleChildHeight = in.readInt();
            this.prevScrolledChildrenHeight = in.readInt();
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
            this.childrenHeights = new SparseIntArray();
            int numOfChildren = in.readInt();
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    int key = in.readInt();
                    int value = in.readInt();
                    this.childrenHeights.put(key, value);
                }
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.prevFirstVisiblePosition);
            out.writeInt(this.prevFirstVisibleChildHeight);
            out.writeInt(this.prevScrolledChildrenHeight);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
            int numOfChildren = this.childrenHeights == null ? 0 : this.childrenHeights.size();
            out.writeInt(numOfChildren);
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    out.writeInt(this.childrenHeights.keyAt(i));
                    out.writeInt(this.childrenHeights.valueAt(i));
                }
            }
        }
    }
}

