/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksoichiro.android.observablescrollview;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.GridView;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import com.github.ksoichiro.android.observablescrollview.Scrollable;

public class ObservableGridView
extends GridView
implements Scrollable {
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private int mPrevScrollY;
    private int mScrollY;
    private SparseIntArray mChildrenHeights;
    private ObservableScrollViewCallbacks mCallbacks;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private MotionEvent mPrevMoveEvent;
    private ViewGroup mTouchInterceptionViewGroup;
    private AbsListView.OnScrollListener mOriginalScrollListener;
    private AbsListView.OnScrollListener mScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (ObservableGridView.this.mOriginalScrollListener != null) {
                ObservableGridView.this.mOriginalScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (ObservableGridView.this.mOriginalScrollListener != null) {
                ObservableGridView.this.mOriginalScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            ObservableGridView.this.onScrollChanged();
        }
    };

    public ObservableGridView(Context context) {
        super(context);
        this.init();
    }

    public ObservableGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ObservableGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mScrollState);
                    break;
                }
                case 2: {
                    if (this.mPrevMoveEvent == null) {
                        this.mPrevMoveEvent = ev;
                    }
                    float diffY = ev.getY() - this.mPrevMoveEvent.getY();
                    this.mPrevMoveEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    if (!((float)this.getCurrentScrollY() - diffY <= 0.0f)) break;
                    if (this.mIntercepted) {
                        return false;
                    }
                    final ViewGroup parent = this.mTouchInterceptionViewGroup == null ? (ViewGroup)this.getParent() : this.mTouchInterceptionViewGroup;
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    for (ObservableGridView v = this; v != null && v != parent; v = (View)v.getParent()) {
                        offsetX += (float)(v.getLeft() - v.getScrollX());
                        offsetY += (float)(v.getTop() - v.getScrollY());
                    }
                    final MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    event.offsetLocation(offsetX, offsetY);
                    if (parent.onInterceptTouchEvent(event)) {
                        this.mIntercepted = true;
                        event.setAction(0);
                        this.post(new Runnable(){

                            @Override
                            public void run() {
                                parent.dispatchTouchEvent(event);
                            }
                        });
                        return false;
                    }
                    return super.onTouchEvent(ev);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOriginalScrollListener = l;
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    @Override
    public void setTouchInterceptionViewGroup(ViewGroup viewGroup) {
        this.mTouchInterceptionViewGroup = viewGroup;
    }

    @Override
    public void scrollVerticallyTo(int y) {
        this.scrollTo(0, y);
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    private void init() {
        this.mChildrenHeights = new SparseIntArray();
        super.setOnScrollListener(this.mScrollListener);
    }

    private void onScrollChanged() {
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int i = this.getFirstVisiblePosition();
            int j = 0;
            while (i <= this.getLastVisiblePosition()) {
                if (this.mChildrenHeights.indexOfKey(i) < 0 || this.getChildAt(j).getHeight() != this.mChildrenHeights.get(i)) {
                    this.mChildrenHeights.put(i, this.getChildAt(j).getHeight());
                }
                ++i;
                ++j;
            }
            View firstVisibleChild = this.getChildAt(0);
            if (firstVisibleChild != null) {
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        for (int i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 >= this.mChildrenHeights.indexOfKey(i2)) continue;
                            skippedChildrenHeight += this.mChildrenHeights.get(i2);
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        for (int i3 = this.mPrevFirstVisiblePosition - 1; i3 > firstVisiblePosition; --i3) {
                            if (0 >= this.mChildrenHeights.indexOfKey(i3)) continue;
                            skippedChildrenHeight += this.mChildrenHeights.get(i3);
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mScrollState = this.mPrevScrollY < this.mScrollY ? ScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ScrollState.DOWN : ScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            }
        }
    }

    static class SavedState
    extends View.BaseSavedState {
        int prevFirstVisiblePosition;
        int prevFirstVisibleChildHeight = -1;
        int prevScrolledChildrenHeight;
        int prevScrollY;
        int scrollY;
        SparseIntArray childrenHeights;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.prevFirstVisiblePosition = in.readInt();
            this.prevFirstVisibleChildHeight = in.readInt();
            this.prevScrolledChildrenHeight = in.readInt();
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
            this.childrenHeights = new SparseIntArray();
            int numOfChildren = in.readInt();
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    int key = in.readInt();
                    int value = in.readInt();
                    this.childrenHeights.put(key, value);
                }
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.prevFirstVisiblePosition);
            out.writeInt(this.prevFirstVisibleChildHeight);
            out.writeInt(this.prevScrolledChildrenHeight);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
            int numOfChildren = this.childrenHeights == null ? 0 : this.childrenHeights.size();
            out.writeInt(numOfChildren);
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    out.writeInt(this.childrenHeights.keyAt(i));
                    out.writeInt(this.childrenHeights.valueAt(i));
                }
            }
        }
    }
}

