/*
 * Decompiled with CFR 0.152.
 */
package com.github.ksoichiro.android.observablescrollview;

import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.FrameLayout;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.WrapperListAdapter;
import com.github.ksoichiro.android.observablescrollview.ObservableScrollViewCallbacks;
import com.github.ksoichiro.android.observablescrollview.ScrollState;
import com.github.ksoichiro.android.observablescrollview.Scrollable;
import java.util.ArrayList;

public class ObservableGridView
extends GridView
implements Scrollable {
    private int mPrevFirstVisiblePosition;
    private int mPrevFirstVisibleChildHeight = -1;
    private int mPrevScrolledChildrenHeight;
    private int mPrevScrollY;
    private int mScrollY;
    private SparseIntArray mChildrenHeights;
    private ObservableScrollViewCallbacks mCallbacks;
    private ScrollState mScrollState;
    private boolean mFirstScroll;
    private boolean mDragging;
    private boolean mIntercepted;
    private MotionEvent mPrevMoveEvent;
    private ViewGroup mTouchInterceptionViewGroup;
    private ArrayList<FixedViewInfo> mHeaderViewInfos;
    private ArrayList<FixedViewInfo> mFooterViewInfos;
    private AbsListView.OnScrollListener mOriginalScrollListener;
    private AbsListView.OnScrollListener mScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (ObservableGridView.this.mOriginalScrollListener != null) {
                ObservableGridView.this.mOriginalScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            if (ObservableGridView.this.mOriginalScrollListener != null) {
                ObservableGridView.this.mOriginalScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            ObservableGridView.this.onScrollChanged();
        }
    };

    public ObservableGridView(Context context) {
        super(context);
        this.init();
    }

    public ObservableGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ObservableGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        this.mPrevFirstVisiblePosition = ss.prevFirstVisiblePosition;
        this.mPrevFirstVisibleChildHeight = ss.prevFirstVisibleChildHeight;
        this.mPrevScrolledChildrenHeight = ss.prevScrolledChildrenHeight;
        this.mPrevScrollY = ss.prevScrollY;
        this.mScrollY = ss.scrollY;
        this.mChildrenHeights = ss.childrenHeights;
        super.onRestoreInstanceState(ss.getSuperState());
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.prevFirstVisiblePosition = this.mPrevFirstVisiblePosition;
        ss.prevFirstVisibleChildHeight = this.mPrevFirstVisibleChildHeight;
        ss.prevScrolledChildrenHeight = this.mPrevScrolledChildrenHeight;
        ss.prevScrollY = this.mPrevScrollY;
        ss.scrollY = this.mScrollY;
        ss.childrenHeights = this.mChildrenHeights;
        return ss;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 0: {
                    this.mDragging = true;
                    this.mFirstScroll = true;
                    this.mCallbacks.onDownMotionEvent();
                }
            }
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mCallbacks != null) {
            switch (ev.getActionMasked()) {
                case 1: 
                case 3: {
                    this.mIntercepted = false;
                    this.mDragging = false;
                    this.mCallbacks.onUpOrCancelMotionEvent(this.mScrollState);
                    break;
                }
                case 2: {
                    if (this.mPrevMoveEvent == null) {
                        this.mPrevMoveEvent = ev;
                    }
                    float diffY = ev.getY() - this.mPrevMoveEvent.getY();
                    this.mPrevMoveEvent = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    if (!((float)this.getCurrentScrollY() - diffY <= 0.0f)) break;
                    if (this.mIntercepted) {
                        return false;
                    }
                    final ViewGroup parent = this.mTouchInterceptionViewGroup == null ? (ViewGroup)this.getParent() : this.mTouchInterceptionViewGroup;
                    float offsetX = 0.0f;
                    float offsetY = 0.0f;
                    for (ObservableGridView v = this; v != null && v != parent; v = (View)v.getParent()) {
                        offsetX += (float)(v.getLeft() - v.getScrollX());
                        offsetY += (float)(v.getTop() - v.getScrollY());
                    }
                    final MotionEvent event = MotionEvent.obtainNoHistory((MotionEvent)ev);
                    event.offsetLocation(offsetX, offsetY);
                    if (parent.onInterceptTouchEvent(event)) {
                        this.mIntercepted = true;
                        event.setAction(0);
                        this.post(new Runnable(){

                            @Override
                            public void run() {
                                parent.dispatchTouchEvent(event);
                            }
                        });
                        return false;
                    }
                    return super.onTouchEvent(ev);
                }
            }
        }
        return super.onTouchEvent(ev);
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        ListAdapter mAdapter = this.getAdapter();
        if (mAdapter != null && !(mAdapter instanceof HeaderViewGridAdapter)) {
            throw new IllegalStateException("Cannot add header view to grid -- setAdapter has already been called.");
        }
        ViewGroup.LayoutParams lyp = v.getLayoutParams();
        FixedViewInfo info = new FixedViewInfo();
        FullWidthFixedViewLayout fl = new FullWidthFixedViewLayout(this.getContext());
        if (lyp != null) {
            v.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(lyp.width, lyp.height));
            fl.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(lyp.width, lyp.height));
        }
        fl.addView(v);
        info.view = v;
        info.viewContainer = fl;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (mAdapter != null) {
            ((HeaderViewGridAdapter)mAdapter).notifyDataSetChanged();
        }
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            ListAdapter adapter = this.getAdapter();
            if (adapter != null && ((HeaderViewGridAdapter)adapter).removeFooter(v)) {
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOriginalScrollListener = l;
    }

    @Override
    public void setScrollViewCallbacks(ObservableScrollViewCallbacks listener) {
        this.mCallbacks = listener;
    }

    @Override
    public void setTouchInterceptionViewGroup(ViewGroup viewGroup) {
        this.mTouchInterceptionViewGroup = viewGroup;
    }

    @Override
    public void scrollVerticallyTo(int y) {
        this.scrollTo(0, y);
    }

    @Override
    public int getCurrentScrollY() {
        return this.mScrollY;
    }

    public void setClipChildren(boolean clipChildren) {
    }

    public void setAdapter(ListAdapter adapter) {
        if (0 < this.mHeaderViewInfos.size()) {
            HeaderViewGridAdapter headerViewGridAdapter = new HeaderViewGridAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter);
            int numColumns = this.getNumColumnsCompat();
            if (1 < numColumns) {
                headerViewGridAdapter.setNumColumns(numColumns);
            }
            super.setAdapter((ListAdapter)headerViewGridAdapter);
        } else {
            super.setAdapter(adapter);
        }
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && !(adapter instanceof HeaderViewGridAdapter)) {
            throw new IllegalStateException("Cannot add header view to grid -- setAdapter has already been called.");
        }
        FixedViewInfo info = new FixedViewInfo();
        FullWidthFixedViewLayout fl = new FullWidthFixedViewLayout(this.getContext());
        fl.addView(v);
        info.view = v;
        info.viewContainer = fl;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (adapter != null) {
            ((HeaderViewGridAdapter)adapter).notifyDataSetChanged();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    public int getHeaderViewCount() {
        return this.mHeaderViewInfos.size();
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            ListAdapter adapter = this.getAdapter();
            if (adapter != null && adapter instanceof HeaderViewGridAdapter && ((HeaderViewGridAdapter)adapter).removeHeader(v)) {
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter instanceof HeaderViewGridAdapter) {
            ((HeaderViewGridAdapter)adapter).setNumColumns(this.getNumColumnsCompat());
        }
    }

    private void init() {
        this.mChildrenHeights = new SparseIntArray();
        this.mHeaderViewInfos = new ArrayList();
        this.mFooterViewInfos = new ArrayList();
        super.setClipChildren(false);
        super.setOnScrollListener(this.mScrollListener);
    }

    private int getNumColumnsCompat() {
        int width;
        if (Build.VERSION.SDK_INT >= 11) {
            return this.getNumColumns();
        }
        int columns = 0;
        if (this.getChildCount() > 0 && (width = this.getChildAt(0).getMeasuredWidth()) > 0) {
            columns = this.getWidth() / width;
        }
        return columns > 0 ? columns : -1;
    }

    private void onScrollChanged() {
        if (this.mCallbacks != null && this.getChildCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int i = this.getFirstVisiblePosition();
            int j = 0;
            while (i <= this.getLastVisiblePosition()) {
                if ((this.mChildrenHeights.indexOfKey(i) < 0 || this.getChildAt(j).getHeight() != this.mChildrenHeights.get(i)) && i % this.getNumColumnsCompat() == 0) {
                    this.mChildrenHeights.put(i, this.getChildAt(j).getHeight());
                }
                ++i;
                ++j;
            }
            View firstVisibleChild = this.getChildAt(0);
            if (firstVisibleChild != null) {
                int skippedChildrenHeight;
                if (this.mPrevFirstVisiblePosition < firstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (firstVisiblePosition - this.mPrevFirstVisiblePosition != 1) {
                        for (int i2 = firstVisiblePosition - 1; i2 > this.mPrevFirstVisiblePosition; --i2) {
                            if (0 >= this.mChildrenHeights.indexOfKey(i2)) continue;
                            skippedChildrenHeight += this.mChildrenHeights.get(i2);
                        }
                    }
                    this.mPrevScrolledChildrenHeight += this.mPrevFirstVisibleChildHeight + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition < this.mPrevFirstVisiblePosition) {
                    skippedChildrenHeight = 0;
                    if (this.mPrevFirstVisiblePosition - firstVisiblePosition != 1) {
                        for (int i3 = this.mPrevFirstVisiblePosition - 1; i3 > firstVisiblePosition; --i3) {
                            if (0 >= this.mChildrenHeights.indexOfKey(i3)) continue;
                            skippedChildrenHeight += this.mChildrenHeights.get(i3);
                        }
                    }
                    this.mPrevScrolledChildrenHeight -= firstVisibleChild.getHeight() + skippedChildrenHeight;
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                } else if (firstVisiblePosition == 0) {
                    this.mPrevFirstVisibleChildHeight = firstVisibleChild.getHeight();
                }
                if (this.mPrevFirstVisibleChildHeight < 0) {
                    this.mPrevFirstVisibleChildHeight = 0;
                }
                this.mScrollY = this.mPrevScrolledChildrenHeight - firstVisibleChild.getTop();
                this.mPrevFirstVisiblePosition = firstVisiblePosition;
                this.mCallbacks.onScrollChanged(this.mScrollY, this.mFirstScroll, this.mDragging);
                if (this.mFirstScroll) {
                    this.mFirstScroll = false;
                }
                this.mScrollState = this.mPrevScrollY < this.mScrollY ? ScrollState.UP : (this.mScrollY < this.mPrevScrollY ? ScrollState.DOWN : ScrollState.STOP);
                this.mPrevScrollY = this.mScrollY;
            }
        }
    }

    private void removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            FixedViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    public static class HeaderViewGridAdapter
    implements WrapperListAdapter,
    Filterable {
        private final DataSetObservable mDataSetObservable = new DataSetObservable();
        private final ListAdapter mAdapter;
        static final ArrayList<FixedViewInfo> EMPTY_INFO_LIST = new ArrayList();
        ArrayList<FixedViewInfo> mHeaderViewInfos;
        ArrayList<FixedViewInfo> mFooterViewInfos;
        private int mNumColumns = 1;
        private int mRowHeight = -1;
        boolean mAreAllFixedViewsSelectable;
        private final boolean mIsFilterable;
        private boolean mCachePlaceHoldView = true;
        private boolean mCacheFirstHeaderView = false;

        public HeaderViewGridAdapter(ArrayList<FixedViewInfo> headerViewInfos, ArrayList<FixedViewInfo> footViewInfos, ListAdapter adapter) {
            this.mAdapter = adapter;
            this.mIsFilterable = adapter instanceof Filterable;
            this.mHeaderViewInfos = headerViewInfos == null ? EMPTY_INFO_LIST : headerViewInfos;
            this.mFooterViewInfos = footViewInfos == null ? EMPTY_INFO_LIST : footViewInfos;
            this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
        }

        public void setNumColumns(int numColumns) {
            if (numColumns < 1) {
                return;
            }
            if (this.mNumColumns != numColumns) {
                this.mNumColumns = numColumns;
                this.notifyDataSetChanged();
            }
        }

        public void setRowHeight(int height) {
            this.mRowHeight = height;
        }

        public int getHeadersCount() {
            return this.mHeaderViewInfos.size();
        }

        public int getFootersCount() {
            return this.mFooterViewInfos.size();
        }

        public boolean isEmpty() {
            return this.mAdapter == null || this.mAdapter.isEmpty();
        }

        private boolean areAllListInfosSelectable(ArrayList<FixedViewInfo> infos) {
            if (infos != null) {
                for (FixedViewInfo info : infos) {
                    if (info.isSelectable) continue;
                    return false;
                }
            }
            return true;
        }

        public boolean removeHeader(View v) {
            for (int i = 0; i < this.mHeaderViewInfos.size(); ++i) {
                FixedViewInfo info = this.mHeaderViewInfos.get(i);
                if (info.view != v) continue;
                this.mHeaderViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                this.mDataSetObservable.notifyChanged();
                return true;
            }
            return false;
        }

        public boolean removeFooter(View v) {
            for (int i = 0; i < this.mFooterViewInfos.size(); ++i) {
                FixedViewInfo info = this.mFooterViewInfos.get(i);
                if (info.view != v) continue;
                this.mFooterViewInfos.remove(i);
                this.mAreAllFixedViewsSelectable = this.areAllListInfosSelectable(this.mHeaderViewInfos) && this.areAllListInfosSelectable(this.mFooterViewInfos);
                this.mDataSetObservable.notifyChanged();
                return true;
            }
            return false;
        }

        public int getCount() {
            if (this.mAdapter != null) {
                return (this.getFootersCount() + this.getHeadersCount()) * this.mNumColumns + this.getAdapterAndPlaceHolderCount();
            }
            return (this.getFootersCount() + this.getHeadersCount()) * this.mNumColumns;
        }

        public boolean areAllItemsEnabled() {
            return this.mAdapter == null || this.mAreAllFixedViewsSelectable && this.mAdapter.areAllItemsEnabled();
        }

        private int getAdapterAndPlaceHolderCount() {
            return (int)(Math.ceil(1.0f * (float)this.mAdapter.getCount() / (float)this.mNumColumns) * (double)this.mNumColumns);
        }

        public boolean isEnabled(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                return position % this.mNumColumns == 0 && this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).isSelectable;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                return adjPosition < this.mAdapter.getCount() && this.mAdapter.isEnabled(adjPosition);
            }
            int footerPosition = adjPosition - adapterCount;
            return footerPosition % this.mNumColumns == 0 && this.mFooterViewInfos.get((int)(footerPosition / this.mNumColumns)).isSelectable;
        }

        public Object getItem(int position) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                if (position % this.mNumColumns == 0) {
                    return this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).data;
                }
                return null;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                if (adjPosition < this.mAdapter.getCount()) {
                    return this.mAdapter.getItem(adjPosition);
                }
                return null;
            }
            int footerPosition = adjPosition - adapterCount;
            if (footerPosition % this.mNumColumns == 0) {
                return this.mFooterViewInfos.get((int)footerPosition).data;
            }
            return null;
        }

        public long getItemId(int position) {
            int adapterCount;
            int adjPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (this.mAdapter != null && position >= numHeadersAndPlaceholders && (adjPosition = position - numHeadersAndPlaceholders) < (adapterCount = this.mAdapter.getCount())) {
                return this.mAdapter.getItemId(adjPosition);
            }
            return -1L;
        }

        public boolean hasStableIds() {
            return this.mAdapter != null && this.mAdapter.hasStableIds();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            if (position < numHeadersAndPlaceholders) {
                ViewGroup headerViewContainer = this.mHeaderViewInfos.get((int)(position / this.mNumColumns)).viewContainer;
                if (position % this.mNumColumns == 0) {
                    return headerViewContainer;
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(headerViewContainer.getHeight());
                return convertView;
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null && adjPosition < (adapterCount = this.getAdapterAndPlaceHolderCount())) {
                if (adjPosition < this.mAdapter.getCount()) {
                    return this.mAdapter.getView(adjPosition, convertView, parent);
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(this.mRowHeight);
                return convertView;
            }
            int footerPosition = adjPosition - adapterCount;
            if (footerPosition < this.getCount()) {
                ViewGroup footViewContainer = this.mFooterViewInfos.get((int)(footerPosition / this.mNumColumns)).viewContainer;
                if (position % this.mNumColumns == 0) {
                    return footViewContainer;
                }
                if (convertView == null) {
                    convertView = new View(parent.getContext());
                }
                convertView.setVisibility(4);
                convertView.setMinimumHeight(footViewContainer.getHeight());
                return convertView;
            }
            throw new ArrayIndexOutOfBoundsException(position);
        }

        public int getItemViewType(int position) {
            int footerPosition;
            int numHeadersAndPlaceholders = this.getHeadersCount() * this.mNumColumns;
            int adapterViewTypeStart = this.mAdapter == null ? 0 : this.mAdapter.getViewTypeCount() - 1;
            int type = -2;
            if (this.mCachePlaceHoldView && position < numHeadersAndPlaceholders) {
                if (position == 0 && this.mCacheFirstHeaderView) {
                    type = adapterViewTypeStart + this.mHeaderViewInfos.size() + this.mFooterViewInfos.size() + 1 + 1;
                }
                if (position % this.mNumColumns != 0) {
                    type = adapterViewTypeStart + (position / this.mNumColumns + 1);
                }
            }
            int adjPosition = position - numHeadersAndPlaceholders;
            int adapterCount = 0;
            if (this.mAdapter != null) {
                adapterCount = this.getAdapterAndPlaceHolderCount();
                if (adjPosition >= 0 && adjPosition < adapterCount) {
                    if (adjPosition < this.mAdapter.getCount()) {
                        type = this.mAdapter.getItemViewType(adjPosition);
                    } else if (this.mCachePlaceHoldView) {
                        type = adapterViewTypeStart + this.mHeaderViewInfos.size() + 1;
                    }
                }
            }
            if (this.mCachePlaceHoldView && (footerPosition = adjPosition - adapterCount) >= 0 && footerPosition < this.getCount() && footerPosition % this.mNumColumns != 0) {
                type = adapterViewTypeStart + this.mHeaderViewInfos.size() + 1 + (footerPosition / this.mNumColumns + 1);
            }
            return type;
        }

        public int getViewTypeCount() {
            int count;
            int n = count = this.mAdapter == null ? 1 : this.mAdapter.getViewTypeCount();
            if (this.mCachePlaceHoldView) {
                int offset = this.mHeaderViewInfos.size() + 1 + this.mFooterViewInfos.size();
                if (this.mCacheFirstHeaderView) {
                    ++offset;
                }
                count += offset;
            }
            return count;
        }

        public void registerDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.registerObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.registerDataSetObserver(observer);
            }
        }

        public void unregisterDataSetObserver(DataSetObserver observer) {
            this.mDataSetObservable.unregisterObserver((Object)observer);
            if (this.mAdapter != null) {
                this.mAdapter.unregisterDataSetObserver(observer);
            }
        }

        public Filter getFilter() {
            if (this.mIsFilterable) {
                return ((Filterable)this.mAdapter).getFilter();
            }
            return null;
        }

        public ListAdapter getWrappedAdapter() {
            return this.mAdapter;
        }

        public void notifyDataSetChanged() {
            this.mDataSetObservable.notifyChanged();
        }
    }

    public static class FixedViewInfo {
        public View view;
        public ViewGroup viewContainer;
        public Object data;
        public boolean isSelectable;
    }

    static class SavedState
    extends View.BaseSavedState {
        int prevFirstVisiblePosition;
        int prevFirstVisibleChildHeight = -1;
        int prevScrolledChildrenHeight;
        int prevScrollY;
        int scrollY;
        SparseIntArray childrenHeights;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.prevFirstVisiblePosition = in.readInt();
            this.prevFirstVisibleChildHeight = in.readInt();
            this.prevScrolledChildrenHeight = in.readInt();
            this.prevScrollY = in.readInt();
            this.scrollY = in.readInt();
            this.childrenHeights = new SparseIntArray();
            int numOfChildren = in.readInt();
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    int key = in.readInt();
                    int value = in.readInt();
                    this.childrenHeights.put(key, value);
                }
            }
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.prevFirstVisiblePosition);
            out.writeInt(this.prevFirstVisibleChildHeight);
            out.writeInt(this.prevScrolledChildrenHeight);
            out.writeInt(this.prevScrollY);
            out.writeInt(this.scrollY);
            int numOfChildren = this.childrenHeights == null ? 0 : this.childrenHeights.size();
            out.writeInt(numOfChildren);
            if (0 < numOfChildren) {
                for (int i = 0; i < numOfChildren; ++i) {
                    out.writeInt(this.childrenHeights.keyAt(i));
                    out.writeInt(this.childrenHeights.valueAt(i));
                }
            }
        }
    }

    private class FullWidthFixedViewLayout
    extends FrameLayout {
        public FullWidthFixedViewLayout(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int targetWidth = ObservableGridView.this.getMeasuredWidth() - ObservableGridView.this.getPaddingLeft() - ObservableGridView.this.getPaddingRight();
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)targetWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }
}

