/*
 * Decompiled with CFR 0.152.
 */
package com.kuaidi100.sdk.utils;

import com.kuaidi100.sdk.pojo.HttpResult;
import com.kuaidi100.sdk.utils.ObjectToMapUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static final String CHARSET_DEFAULT = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult doPost(String url, Object obj, int connectTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            Map<String, String> params = ObjectToMapUtils.objectToMap(obj);
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            httpPost.setConfig(requestConfig);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
                }
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(list, CHARSET_DEFAULT));
            }
            resp = httpClient.execute((HttpUriRequest)httpPost);
            String body = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)CHARSET_DEFAULT);
            int statusCode = resp.getStatusLine().getStatusCode();
            result.setStatus(statusCode);
            result.setBody(body);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != resp) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResult doPostFile(String url, File file, int connectTimeout, int socketTimeout) {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        CloseableHttpResponse resp = null;
        HttpResult result = new HttpResult();
        try {
            HttpPost httpPost = new HttpPost(url);
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectTimeout).setSocketTimeout(socketTimeout).build();
            httpPost.setConfig(requestConfig);
            builder.addBinaryBody("file", (InputStream)new FileInputStream(file), ContentType.MULTIPART_FORM_DATA, file.getName());
            HttpEntity entity = builder.build();
            httpPost.setEntity(entity);
            resp = httpClient.execute((HttpUriRequest)httpPost);
            result.setStatus(resp.getStatusLine().getStatusCode());
            result.setBody(EntityUtils.toString((HttpEntity)resp.getEntity(), (String)CHARSET_DEFAULT));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (null != resp) {
                try {
                    resp.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

