/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration;

import com.kuliginstepan.mongration.MongrationException;
import com.kuliginstepan.mongration.annotation.Changelog;
import com.kuliginstepan.mongration.annotation.Changeset;
import com.kuliginstepan.mongration.configuration.MongrationProperties;
import com.kuliginstepan.mongration.entity.ChangesetEntity;
import com.kuliginstepan.mongration.service.AbstractChangeSetService;
import com.kuliginstepan.mongration.service.IndexCreator;
import com.kuliginstepan.mongration.service.LockService;
import com.kuliginstepan.mongration.utils.ChangelogUtils;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.StringUtils;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public abstract class AbstractMongration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMongration.class);
    private final AbstractChangeSetService changesetService;
    private final IndexCreator indexCreator;
    private final LockService lockService;
    private final MongrationProperties properties;
    protected ApplicationContext context;

    @EventListener
    public void start(ApplicationReadyEvent event) {
        this.context = event.getApplicationContext();
        log.info("mongration started");
        this.findMigrationsForExecution().flatMap(tuple -> this.withLockAcquired((Mono<Void>)Mono.defer(() -> this.executeMigration((List<Tuple2<Object, List<Method>>>)tuple)))).block();
        log.info("mongration finished its work");
    }

    protected Mono<Void> withLockAcquired(Mono<Void> action) {
        return this.acquireLock().then(action.onErrorResume(throwable -> this.lockService.releaseLock().onErrorResume(releasingException -> {
            throwable.addSuppressed((Throwable)releasingException);
            return Mono.empty();
        }).then(Mono.error((Throwable)throwable))).then(Mono.defer(this.lockService::releaseLock)));
    }

    protected Mono<Void> acquireLock() {
        AtomicInteger counter = new AtomicInteger(0);
        return Mono.defer(this.lockService::acquireLock).retryWhen(companion -> companion.zipWith((Publisher)Flux.range((int)1, (int)(this.properties.getRetryCount() + 1)), this::handleFailedTry).flatMap(index -> Mono.delay((Duration)this.properties.getRetryDelay())).doOnNext(s -> log.warn("mongration retried {} time at {}", (Object)counter.incrementAndGet(), (Object)LocalTime.now())));
    }

    private Integer handleFailedTry(Throwable error, Integer tryNumber) {
        if (!(error instanceof MongrationException) || tryNumber > this.properties.getRetryCount()) {
            throw Exceptions.propagate((Throwable)error);
        }
        return tryNumber;
    }

    protected abstract Mono<Object> executeChangeSetMethod(Object var1, Method var2);

    protected List<String> doValidateChangelog(Class<?> changelogClass) {
        List<Method> changesetMethods = ChangelogUtils.findChangeSetMethods(changelogClass);
        long distinctOrderCount = changesetMethods.stream().map(ChangelogUtils::extractChangeset).map(Changeset::order).distinct().count();
        long distinctIdCount = changesetMethods.stream().map(method -> Optional.of(method).map(ChangelogUtils::extractChangeset).map(Changeset::id).filter(StringUtils::hasText).orElseGet(method::getName)).distinct().count();
        ArrayList<String> errors = new ArrayList<String>();
        if (distinctOrderCount != (long)changesetMethods.size()) {
            errors.add("Several change sets have same order");
        }
        if (distinctIdCount != (long)changesetMethods.size()) {
            errors.add("Several change sets have same id's");
        }
        return errors;
    }

    private Mono<Void> validateChangelog(Class<?> changelogClass) {
        List<String> errors = this.doValidateChangelog(changelogClass);
        return errors.isEmpty() ? Mono.empty() : Mono.error(() -> new MongrationException(String.join((CharSequence)",", errors)));
    }

    private Mono<List<Tuple2<Object, List<Method>>>> findMigrationsForExecution() {
        return Flux.fromIterable(this.context.getBeansWithAnnotation(Changelog.class).values()).flatMap(changelog -> this.validateChangelog(ChangelogUtils.getChangelogClass(changelog)).thenMany((Publisher)Flux.fromIterable(ChangelogUtils.findChangeSetMethods(ChangelogUtils.getChangelogClass(changelog)))).collectSortedList(Comparator.comparingInt(method -> ChangelogUtils.extractChangeset(method).order())).map(changesets -> Tuples.of((Object)changelog, (Object)changesets))).sort((x, y) -> AnnotationAwareOrderComparator.INSTANCE.compare(x.getT1(), y.getT1())).collectList();
    }

    private Mono<Void> executeMigration(List<Tuple2<Object, List<Method>>> changelogs) {
        return this.indexCreator.createIndexes(ChangesetEntity.class).then(Mono.defer(() -> {
            log.info("started executing migrations");
            changelogs.forEach(this::executeChangelogMigrations);
            return this.indexCreator.createIndexes();
        }));
    }

    private void executeChangelogMigrations(Tuple2<Object, List<Method>> changelogTuple) {
        ((List)changelogTuple.getT2()).forEach(changeset -> Mono.just((Object)changelogTuple.getT1()).filterWhen(changelog -> this.changesetService.needExecuteChangeset((Method)changeset, changelog)).flatMap(changelog -> this.executeMigration(changelog, (Method)changeset)).block());
    }

    private Mono<Void> executeMigration(Object changelog, Method changesetMethod) {
        return this.changesetService.validateChangesetMethodSignature(changesetMethod).then(Mono.defer(() -> this.executeChangeSetMethod(changelog, changesetMethod))).then(Mono.defer(() -> this.changesetService.saveChangeset(changesetMethod, changelog))).onErrorMap(t -> new MongrationException("Could't execute changeset: " + changesetMethod.getName(), (Throwable)t));
    }

    @Generated
    public AbstractMongration(AbstractChangeSetService changesetService, IndexCreator indexCreator, LockService lockService, MongrationProperties properties) {
        this.changesetService = changesetService;
        this.indexCreator = indexCreator;
        this.lockService = lockService;
        this.properties = properties;
    }
}

