/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.actuator;

import com.kuliginstepan.mongration.actuator.MongrationEndpoint;
import com.kuliginstepan.mongration.actuator.ReactiveMongrationEndpoint;
import com.kuliginstepan.mongration.configuration.MongrationAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Endpoint.class})
@AutoConfigureAfter(value={MongrationAutoConfiguration.class})
public class MongrationActuatorAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={ReactiveMongoTemplate.class})
    @ConditionalOnAvailableEndpoint(endpoint=ReactiveMongrationEndpoint.class)
    public static class ReactiveMongrationEndpointConfiguration {
        @Bean
        public ReactiveMongrationEndpoint reactiveMongrationEndpoint(ReactiveMongoTemplate template) {
            return new ReactiveMongrationEndpoint(template);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnBean(value={MongoTemplate.class})
    @ConditionalOnMissingBean(value={ReactiveMongoTemplate.class})
    @ConditionalOnAvailableEndpoint(endpoint=MongrationEndpoint.class)
    public static class MongrationEndpointConfiguration {
        @Bean
        public MongrationEndpoint mongrationEndpoint(MongoTemplate template) {
            return new MongrationEndpoint(template);
        }
    }
}

