/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.configuration;

import com.kuliginstepan.mongration.annotation.Changelog;
import com.kuliginstepan.mongration.configuration.ConditionalOnMongrationMode;
import com.kuliginstepan.mongration.configuration.MongrationMode;
import com.kuliginstepan.mongration.utils.ChangelogUtils;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

public class OnMongrationModeCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        Map attributes = metadata.getAnnotationAttributes(ConditionalOnMongrationMode.class.getName(), true);
        MongrationMode requiredType = (MongrationMode)((Object)attributes.get("mode"));
        MongrationMode configuredType = (MongrationMode)((Object)context.getEnvironment().getProperty("mongration.mode", MongrationMode.class, (Object)MongrationMode.AUTO));
        ConditionMessage.Builder messageBuilder = ConditionMessage.forCondition(ConditionalOnMongrationMode.class, (Object[])new Object[0]);
        if (configuredType == requiredType) {
            return ConditionOutcome.match((ConditionMessage)messageBuilder.because("configured type of '" + configuredType.name() + "' matched required type"));
        }
        if (configuredType == MongrationMode.AUTO && this.hasMonoChangeSets(context) && requiredType == MongrationMode.REACTIVE) {
            return ConditionOutcome.match((ConditionMessage)messageBuilder.because("configured type AUTO and changelogs return Mono"));
        }
        if (configuredType == MongrationMode.AUTO && !this.hasMonoChangeSets(context) && requiredType == MongrationMode.IMPERATIVE) {
            return ConditionOutcome.match((ConditionMessage)messageBuilder.because("configured type AUTO and changelogs don't return Mono"));
        }
        return ConditionOutcome.noMatch((ConditionMessage)messageBuilder.because("configured type (" + configuredType.name() + ") did not match required type (" + requiredType.name() + ')'));
    }

    private boolean hasMonoChangeSets(ConditionContext context) {
        return Stream.of(context.getBeanFactory().getBeanNamesForAnnotation(Changelog.class)).map(beanName -> context.getRegistry().getBeanDefinition(beanName)).map(BeanDefinition::getBeanClassName).map(className -> ClassUtils.resolveClassName((String)className, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader())).flatMap(changelog -> ChangelogUtils.findChangeSetMethods(changelog).stream()).anyMatch(method -> method.getReturnType().isAssignableFrom(Mono.class));
    }
}

