/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.entity;

import java.time.Instant;
import lombok.Generated;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.PersistenceConstructor;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="#{@mongrationProperties.getChangelogsCollection()}")
@CompoundIndex(def="{'changeset': 1, 'changelog': 1}", unique=true)
public class ChangesetEntity {
    public static final String CHANGE_SET_KEY = "changeset";
    public static final String CHANGE_LOG_KEY = "changelog";
    @Id
    private String id;
    private final String changeset;
    private final String author;
    private final Instant createdAt;
    private final String changelog;

    public ChangesetEntity(String changeset, String author, String changelog) {
        this.changeset = changeset;
        this.author = author;
        this.changelog = changelog;
        this.createdAt = Instant.now();
    }

    @PersistenceConstructor
    public ChangesetEntity(String id, String changeset, String author, Instant createdAt, String changelog) {
        this.id = id;
        this.changeset = changeset;
        this.author = author;
        this.createdAt = createdAt;
        this.changelog = changelog;
    }

    @Generated
    public static ChangesetEntityBuilder builder() {
        return new ChangesetEntityBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getChangeset() {
        return this.changeset;
    }

    @Generated
    public String getAuthor() {
        return this.author;
    }

    @Generated
    public Instant getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getChangelog() {
        return this.changelog;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangesetEntity)) {
            return false;
        }
        ChangesetEntity other = (ChangesetEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$changeset = this.getChangeset();
        String other$changeset = other.getChangeset();
        if (this$changeset == null ? other$changeset != null : !this$changeset.equals(other$changeset)) {
            return false;
        }
        String this$author = this.getAuthor();
        String other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !this$author.equals(other$author)) {
            return false;
        }
        Instant this$createdAt = this.getCreatedAt();
        Instant other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$changelog = this.getChangelog();
        String other$changelog = other.getChangelog();
        return !(this$changelog == null ? other$changelog != null : !this$changelog.equals(other$changelog));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangesetEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $changeset = this.getChangeset();
        result = result * 59 + ($changeset == null ? 43 : $changeset.hashCode());
        String $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : $author.hashCode());
        Instant $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $changelog = this.getChangelog();
        result = result * 59 + ($changelog == null ? 43 : $changelog.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ChangesetEntity(id=" + this.getId() + ", changeset=" + this.getChangeset() + ", author=" + this.getAuthor() + ", createdAt=" + this.getCreatedAt() + ", changelog=" + this.getChangelog() + ")";
    }

    @Generated
    public static class ChangesetEntityBuilder {
        @Generated
        private String changeset;
        @Generated
        private String author;
        @Generated
        private String changelog;

        @Generated
        ChangesetEntityBuilder() {
        }

        @Generated
        public ChangesetEntityBuilder changeset(String changeset) {
            this.changeset = changeset;
            return this;
        }

        @Generated
        public ChangesetEntityBuilder author(String author) {
            this.author = author;
            return this;
        }

        @Generated
        public ChangesetEntityBuilder changelog(String changelog) {
            this.changelog = changelog;
            return this;
        }

        @Generated
        public ChangesetEntity build() {
            return new ChangesetEntity(this.changeset, this.author, this.changelog);
        }

        @Generated
        public String toString() {
            return "ChangesetEntity.ChangesetEntityBuilder(changeset=" + this.changeset + ", author=" + this.author + ", changelog=" + this.changelog + ")";
        }
    }
}

