/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.service;

import com.kuliginstepan.mongration.annotation.Changeset;
import com.kuliginstepan.mongration.configuration.MongrationProperties;
import com.kuliginstepan.mongration.entity.ChangesetEntity;
import com.kuliginstepan.mongration.utils.ChangelogUtils;
import java.lang.reflect.Method;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public abstract class AbstractChangeSetService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractChangeSetService.class);
    protected final MongrationProperties properties;

    public abstract Mono<Void> validateChangesetMethodSignature(Method var1);

    public Mono<Boolean> needExecuteChangeset(Method changesetMethod, Object changelog) {
        return this.isExistingChangeset(changesetMethod, changelog).map(isExisting -> isExisting == false);
    }

    public Mono<Void> saveChangeset(Method changesetMethod, Object changelog) {
        Changeset changeset = ChangelogUtils.extractChangeset(changesetMethod);
        return this.saveChangesetInternal(AbstractChangeSetService.toEntity(changeset, ChangelogUtils.getChangelogClass(changelog), changesetMethod)).doOnSuccess(entity -> log.info("saved migration: {}", entity)).then();
    }

    protected abstract Mono<ChangesetEntity> saveChangesetInternal(ChangesetEntity var1);

    protected abstract Mono<Boolean> isExistingChangeset(Method var1, Object var2);

    private static ChangesetEntity toEntity(Changeset changeset, Class<?> changelogClass, Method changesetMethod) {
        return ChangesetEntity.builder().changeset(ChangelogUtils.generateChangeSetId(changesetMethod)).author(changeset.author()).changelog(ChangelogUtils.generateChangeLogId(changelogClass)).build();
    }

    @Generated
    public AbstractChangeSetService(MongrationProperties properties) {
        this.properties = properties;
    }
}

