/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.service.impl;

import com.kuliginstepan.mongration.MongrationException;
import com.kuliginstepan.mongration.configuration.MongrationProperties;
import com.kuliginstepan.mongration.entity.ChangesetEntity;
import com.kuliginstepan.mongration.service.AbstractChangeSetService;
import com.kuliginstepan.mongration.utils.ChangelogUtils;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import reactor.core.publisher.Mono;

public class ChangeSetService
extends AbstractChangeSetService {
    private final MongoTemplate template;

    public ChangeSetService(MongrationProperties properties, MongoTemplate template) {
        super(properties);
        this.template = template;
    }

    @Override
    public Mono<Void> validateChangesetMethodSignature(Method changesetMethod) {
        return Mono.just((Object)changesetMethod).map(Method::getReturnType).filter(Void.TYPE::equals).switchIfEmpty(Mono.error(() -> new MongrationException("Change Set method must return 'void'"))).then();
    }

    @Override
    protected Mono<ChangesetEntity> saveChangesetInternal(ChangesetEntity changeset) {
        return Mono.just((Object)((ChangesetEntity)this.template.save((Object)changeset, this.properties.getChangelogsCollection())));
    }

    @Override
    protected Mono<Boolean> isExistingChangeset(Method changesetMethod, Object changelog) {
        return Mono.just((Object)this.template.exists(Query.query((CriteriaDefinition)Criteria.where((String)"changeset").is((Object)ChangelogUtils.generateChangeSetId(changesetMethod)).and("changelog").is((Object)ChangelogUtils.generateChangeLogId(ChangelogUtils.getChangelogClass(changelog)))), this.properties.getChangelogsCollection()));
    }
}

