/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.service.impl;

import com.kuliginstepan.mongration.MongrationException;
import com.kuliginstepan.mongration.service.LockService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import reactor.core.publisher.Mono;

public class LockServiceImpl
implements LockService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LockServiceImpl.class);
    private final String lockCollection;
    private final MongoTemplate template;

    @Override
    public Mono<Void> acquireLock() {
        try {
            this.template.insert((Object)LOCK, this.lockCollection);
            log.trace("Mongration acquired process lock");
            return Mono.empty();
        }
        catch (Exception e) {
            return Mono.error((Throwable)new MongrationException("Mongration couldn't acquire process lock", e));
        }
    }

    @Override
    public Mono<Void> releaseLock() {
        try {
            this.template.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(LOCK.get((Object)"_id"))), this.lockCollection);
            log.trace("Mongration released process lock");
            return Mono.empty();
        }
        catch (Exception e) {
            return Mono.error((Throwable)new MongrationException("Mongration couldn't release process lock", e));
        }
    }

    @Generated
    public LockServiceImpl(String lockCollection, MongoTemplate template) {
        this.lockCollection = lockCollection;
        this.template = template;
    }
}

