/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.service.impl;

import com.kuliginstepan.mongration.MongrationException;
import com.kuliginstepan.mongration.configuration.MongrationProperties;
import com.kuliginstepan.mongration.entity.ChangesetEntity;
import com.kuliginstepan.mongration.service.AbstractChangeSetService;
import com.kuliginstepan.mongration.utils.ChangelogUtils;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import reactor.core.publisher.Mono;

public class ReactiveChangeSetService
extends AbstractChangeSetService {
    private final ReactiveMongoTemplate template;

    public ReactiveChangeSetService(MongrationProperties properties, ReactiveMongoTemplate template) {
        super(properties);
        this.template = template;
    }

    @Override
    public Mono<Void> validateChangesetMethodSignature(Method changesetMethod) {
        return Mono.just((Object)changesetMethod).map(Method::getReturnType).filter(Mono.class::isAssignableFrom).switchIfEmpty(Mono.error(() -> new MongrationException("Change Set method must return 'Mono'"))).then();
    }

    @Override
    protected Mono<ChangesetEntity> saveChangesetInternal(ChangesetEntity changeset) {
        return this.template.save((Object)changeset, this.properties.getChangelogsCollection());
    }

    @Override
    protected Mono<Boolean> isExistingChangeset(Method changesetMethod, Object changelog) {
        return this.template.exists(Query.query((CriteriaDefinition)Criteria.where((String)"changeset").is((Object)ChangelogUtils.generateChangeSetId(changesetMethod)).and("changelog").is((Object)ChangelogUtils.generateChangeLogId(ChangelogUtils.getChangelogClass(changelog)))), this.properties.getChangelogsCollection());
    }
}

