/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.service.impl;

import com.kuliginstepan.mongration.MongrationException;
import com.kuliginstepan.mongration.service.LockService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.ReactiveMongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import reactor.core.publisher.Mono;

public class ReactiveLockServiceImpl
implements LockService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveLockServiceImpl.class);
    private final String lockCollection;
    private final ReactiveMongoTemplate template;

    @Override
    public Mono<Void> acquireLock() {
        return this.template.insert((Object)LOCK, this.lockCollection).onErrorMap(t -> new MongrationException("Mongration couldn't acquire process lock", (Throwable)t)).then(Mono.defer(() -> {
            log.trace("Mongration acquired process lock");
            return Mono.empty();
        }));
    }

    @Override
    public Mono<Void> releaseLock() {
        return this.template.remove(Query.query((CriteriaDefinition)Criteria.where((String)"_id").is(LOCK.get((Object)"_id"))), this.lockCollection).onErrorMap(t -> new MongrationException("Mongration couldn't release process lock", (Throwable)t)).then(Mono.defer(() -> {
            log.trace("Mongration released process lock");
            return Mono.empty();
        }));
    }

    @Generated
    public ReactiveLockServiceImpl(String lockCollection, ReactiveMongoTemplate template) {
        this.lockCollection = lockCollection;
        this.template = template;
    }
}

