/*
 * Decompiled with CFR 0.152.
 */
package com.kuliginstepan.mongration.utils;

import com.kuliginstepan.mongration.annotation.Changelog;
import com.kuliginstepan.mongration.annotation.Changeset;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public final class ChangelogUtils {
    public static Changeset extractChangeset(Method changesetMethod) {
        return (Changeset)AnnotationUtils.getAnnotation((Method)changesetMethod, Changeset.class);
    }

    public static List<Method> findChangeSetMethods(Class<?> changelogClass) {
        return Arrays.stream(changelogClass.getMethods()).filter(method -> method.isAnnotationPresent(Changeset.class)).collect(Collectors.toList());
    }

    public static String generateChangeLogId(Class<?> changelogClass) {
        return Optional.of(changelogClass).map(changelog -> (Changelog)AnnotationUtils.getAnnotation((AnnotatedElement)changelog, Changelog.class)).filter(changelog -> StringUtils.hasLength((String)changelog.id())).map(Changelog::id).orElseGet(changelogClass::getSimpleName);
    }

    public static String generateChangeSetId(Method changesetMethod) {
        return Optional.of(changesetMethod).map(changeset -> (Changeset)AnnotationUtils.getAnnotation((Method)changeset, Changeset.class)).filter(changeset -> StringUtils.hasLength((String)changeset.id())).map(Changeset::id).orElseGet(changesetMethod::getName);
    }

    public static Class<?> getChangelogClass(Object changelog) {
        return AopProxyUtils.ultimateTargetClass((Object)changelog);
    }

    @Generated
    private ChangelogUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

