/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel;

import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.UnexpectedInputException;
import org.springframework.batch.item.excel.ExcelFileParseException;
import org.springframework.batch.item.excel.RowCallbackHandler;
import org.springframework.batch.item.excel.RowMapper;
import org.springframework.batch.item.excel.Sheet;
import org.springframework.batch.item.excel.support.rowset.DefaultRowSetFactory;
import org.springframework.batch.item.excel.support.rowset.RowSet;
import org.springframework.batch.item.excel.support.rowset.RowSetFactory;
import org.springframework.batch.item.file.ResourceAwareItemReaderItemStream;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractExcelItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ResourceAwareItemReaderItemStream<T>,
InitializingBean {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Resource resource;
    private InputStream inputStream;
    private int linesToSkip = 0;
    private int currentSheet = 0;
    private int endAfterBlankLines = 1;
    private RowMapper<T> rowMapper;
    private RowCallbackHandler skippedRowsCallback;
    private boolean noInput = false;
    private boolean strict = true;
    private RowSetFactory rowSetFactory = new DefaultRowSetFactory();
    private RowSet rs;

    public AbstractExcelItemReader() {
        this.setName(ClassUtils.getShortName(((Object)((Object)this)).getClass()));
    }

    public T read() throws Exception, UnexpectedInputException, ParseException {
        Object item = super.read();
        int blankLines = 0;
        while (item == null) {
            if (++blankLines >= this.endAfterBlankLines) {
                return null;
            }
            item = super.read();
            if (item == null) continue;
            return (T)item;
        }
        return (T)item;
    }

    protected T doRead() throws Exception {
        if (this.noInput || this.rs == null) {
            return null;
        }
        if (this.rs.next()) {
            while (null != this.rs.getCurrentRow() && this.isInvalidValidRow(this.rs)) {
                this.rs.next();
            }
            try {
                return this.rowMapper.mapRow(this.rs);
            }
            catch (Exception e) {
                throw new ExcelFileParseException("Exception parsing Excel file.", e, this.resource.getDescription(), this.rs.getMetaData().getSheetName(), this.rs.getCurrentRowIndex(), this.rs.getCurrentRow());
            }
        }
        ++this.currentSheet;
        if (this.currentSheet >= this.getNumberOfSheets()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No more sheets in '" + this.resource.getDescription() + "'."));
            }
            return null;
        }
        this.openSheet();
        return this.doRead();
    }

    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.rs.next();
        }
    }

    private boolean isInvalidValidRow(RowSet rs) {
        for (String str : rs.getCurrentRow()) {
            if (str.length() <= 0) continue;
            return false;
        }
        return true;
    }

    protected void doOpen() throws Exception {
        Assert.notNull((Object)this.resource, (String)"Input resource must be set");
        this.noInput = true;
        if (!this.resource.exists()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must exist (reader is in 'strict' mode): " + this.resource);
            }
            this.logger.warn((Object)("Input resource does not exist '" + this.resource.getDescription() + "'."));
            return;
        }
        if (!this.resource.isReadable()) {
            if (this.strict) {
                throw new IllegalStateException("Input resource must be readable (reader is in 'strict' mode): " + this.resource);
            }
            this.logger.warn((Object)("Input resource is not readable '" + this.resource.getDescription() + "'."));
            return;
        }
        this.inputStream = this.resource.getInputStream();
        this.openExcelFile(this.inputStream);
        this.openSheet();
        this.noInput = false;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opened workbook [" + this.resource.getFilename() + "] with " + this.getNumberOfSheets() + " sheets."));
        }
    }

    private void openSheet() {
        Sheet sheet = this.getSheet(this.currentSheet);
        this.rs = this.rowSetFactory.create(sheet);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Opening sheet " + sheet.getName() + "."));
        }
        for (int i = 0; i < this.linesToSkip; ++i) {
            if (!this.rs.next() || this.skippedRowsCallback == null) continue;
            this.skippedRowsCallback.handleRow(this.rs);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Openend sheet " + sheet.getName() + ", with " + sheet.getNumberOfRows() + " rows."));
        }
    }

    protected void doClose() throws Exception {
        this.currentSheet = 0;
        this.rs = null;
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        this.inputStream = null;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.rowMapper, (String)"RowMapper must be set");
    }

    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    protected abstract Sheet getSheet(int var1);

    protected abstract int getNumberOfSheets();

    protected abstract void openExcelFile(InputStream var1) throws Exception;

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setRowMapper(RowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    public void setRowSetFactory(RowSetFactory rowSetFactory) {
        this.rowSetFactory = rowSetFactory;
    }

    public void setSkippedRowsCallback(RowCallbackHandler skippedRowsCallback) {
        this.skippedRowsCallback = skippedRowsCallback;
    }

    public void setEndAfterBlankLines(int endAfterBlankLines) {
        this.endAfterBlankLines = endAfterBlankLines;
    }
}

