/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.excel.poi;

import java.text.SimpleDateFormat;
import java.util.LinkedList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.batch.item.excel.poi.PoiSheet;

public class DefaulltMappingPoiSheet
extends PoiSheet {
    private CellType defaultCellType = CellType.STRING;

    public DefaulltMappingPoiSheet(Sheet delegate) {
        super(delegate);
    }

    private static String getCellValueAsString(Cell cell) {
        String strCellValue = null;
        if (cell != null) {
            switch (cell.getCellType()) {
                case 1: {
                    strCellValue = cell.toString();
                    break;
                }
                case 0: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
                        strCellValue = dateFormat.format(cell.getDateCellValue());
                        break;
                    }
                    Double value = cell.getNumericCellValue();
                    Long longValue = value.longValue();
                    strCellValue = new String(longValue.toString());
                    break;
                }
                case 4: {
                    strCellValue = new String(new Boolean(cell.getBooleanCellValue()).toString());
                    break;
                }
                case 3: {
                    strCellValue = "";
                }
            }
        }
        return strCellValue;
    }

    @Override
    public String[] getRow(int rowNumber) {
        Row row = this.delegate.getRow(rowNumber);
        if (row == null) {
            return null;
        }
        LinkedList<String> cells = new LinkedList<String>();
        int numberOfColumns = row.getLastCellNum();
        for (int i = 0; i < numberOfColumns; ++i) {
            Cell cell = row.getCell(i);
            cells.add(DefaulltMappingPoiSheet.getCellValueAsString(cell));
        }
        return cells.toArray(new String[0]);
    }
}

