/*
 * Decompiled with CFR 0.152.
 */
package com.github.kwai.open.api;

import com.github.kwai.open.KwaiOpenException;
import com.github.kwai.open.api.IOpenAPI;
import com.github.kwai.open.model.FragmentInfo;
import com.github.kwai.open.request.CreateVideoRequest;
import com.github.kwai.open.request.GetFragmentResumeInfoRequest;
import com.github.kwai.open.request.ResumeFragmentRequest;
import com.github.kwai.open.request.StartUploadRequest;
import com.github.kwai.open.request.UploadCompleteRequest;
import com.github.kwai.open.request.UploadFileRequest;
import com.github.kwai.open.request.UploadFragmentRequest;
import com.github.kwai.open.request.UploadSingleRequest;
import com.github.kwai.open.request.VideoInfoRequest;
import com.github.kwai.open.request.VideoListRequest;
import com.github.kwai.open.request.VideoPublishRequest;
import com.github.kwai.open.response.CreateVideoResponse;
import com.github.kwai.open.response.GetFragmentResumeInfoResponse;
import com.github.kwai.open.response.ResumeFragmentResponse;
import com.github.kwai.open.response.StartUploadResponse;
import com.github.kwai.open.response.UploadCompleteResponse;
import com.github.kwai.open.response.UploadFileResponse;
import com.github.kwai.open.response.UploadFragmentResponse;
import com.github.kwai.open.response.UploadSingleResponse;
import com.github.kwai.open.response.VideoInfoResponse;
import com.github.kwai.open.response.VideoListResponse;
import com.github.kwai.open.response.VideoPublishResponse;
import com.github.kwai.open.utils.ArrayUtils;
import com.github.kwai.open.utils.HttpUtils;
import com.github.kwai.open.utils.ValidatorUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KwaiOpenVideoApi
implements IOpenAPI {
    private String appId = "";

    private KwaiOpenVideoApi(String appId) {
        this.appId = appId;
    }

    public static KwaiOpenVideoApi init(String appId) {
        return new KwaiOpenVideoApi(appId);
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    public StartUploadResponse startUpload(StartUploadRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.postMultipart("https://open.kuaishou.com/openapi/photo/start_upload", request.toQueryParam(this), StartUploadResponse.class);
    }

    public UploadFileResponse uploadFile(UploadFileRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        UploadFileResponse response = new UploadFileResponse();
        response.setUploadToken(request.getUploadToken());
        response.setEndPoint(request.getEndPoint());
        if (request.getFileData().length > 0xA00000) {
            List<byte[]> fragment = ArrayUtils.splitBytes(request.getFileData(), 0xA00000);
            for (int i = 0; i < fragment.size(); ++i) {
                this.uploadFileFragment(new UploadFragmentRequest(request.getUploadToken(), request.getEndPoint(), fragment.get(i), i));
            }
            UploadCompleteResponse uploadCompleteResponse = this.uploadFileFragmentComplete(new UploadCompleteRequest(request.getUploadToken(), request.getEndPoint(), fragment.size()));
            response.setResult(uploadCompleteResponse.getResult());
        } else {
            UploadSingleRequest uploadSingleRequest = new UploadSingleRequest(request.getUploadToken(), request.getEndPoint(), request.getFileData());
            UploadSingleResponse uploadSingleResponse = this.uploadFileSingle(uploadSingleRequest);
            response.setResult(uploadSingleResponse.getResult());
        }
        return response;
    }

    public UploadSingleResponse uploadFileSingle(UploadSingleRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        String url = String.join((CharSequence)"", "http://", request.getEndPoint(), "/api/upload");
        return HttpUtils.postBinary(url, request.toQueryParam(), request.getFileData(), UploadSingleResponse.class);
    }

    public UploadFragmentResponse uploadFileFragment(UploadFragmentRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        String url = String.join((CharSequence)"", "http://", request.getEndPoint(), "/api/upload/fragment");
        return HttpUtils.postBinary(url, request.toQueryParam(), request.getFileData(), UploadFragmentResponse.class);
    }

    public GetFragmentResumeInfoResponse getFragmentResumeInfo(GetFragmentResumeInfoRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        String url = String.join((CharSequence)"", "http://", request.getEndPoint(), "/api/upload/resume");
        return HttpUtils.get(url, request.toQueryParam(), GetFragmentResumeInfoResponse.class);
    }

    public ResumeFragmentResponse resumeFragment(ResumeFragmentRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        ResumeFragmentResponse response = new ResumeFragmentResponse();
        response.setUploadToken(request.getUploadToken());
        response.setEndPoint(request.getEndPoint());
        GetFragmentResumeInfoResponse fragmentResumeInfo = this.getFragmentResumeInfo(new GetFragmentResumeInfoRequest(request.getUploadToken(), request.getEndPoint()));
        if (fragmentResumeInfo.getExisted().booleanValue()) {
            return response;
        }
        if (request.getVideoFileData().length > 0xA00000) {
            List<byte[]> fragment = ArrayUtils.splitBytes(request.getVideoFileData(), 0xA00000);
            Map<Integer, FragmentInfo> donePart = fragmentResumeInfo.getFragmentList().stream().collect(Collectors.toMap(FragmentInfo::getId, fragmentInfo -> fragmentInfo));
            for (int i = 0; i < fragment.size(); ++i) {
                if (donePart.containsKey(i)) continue;
                this.uploadFileFragment(new UploadFragmentRequest(request.getUploadToken(), request.getEndPoint(), fragment.get(i), i));
            }
            UploadCompleteResponse uploadCompleteResponse = this.uploadFileFragmentComplete(new UploadCompleteRequest(request.getUploadToken(), request.getEndPoint(), fragment.size()));
            response.setResult(uploadCompleteResponse.getResult());
        } else {
            UploadSingleRequest uploadSingleRequest = new UploadSingleRequest(request.getUploadToken(), request.getEndPoint(), request.getVideoFileData());
            UploadSingleResponse uploadSingleResponse = this.uploadFileSingle(uploadSingleRequest);
            response.setResult(uploadSingleResponse.getResult());
        }
        return response;
    }

    public UploadCompleteResponse uploadFileFragmentComplete(UploadCompleteRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        String url = String.join((CharSequence)"", "http://", request.getEndPoint(), "/api/upload/complete");
        return HttpUtils.postMultipart(url, request.toQueryParam(), Collections.EMPTY_MAP, UploadCompleteResponse.class);
    }

    public VideoPublishResponse videoPublish(VideoPublishRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.postMultipart("https://open.kuaishou.com/openapi/photo/publish", request.toQueryParam(this), request.toDataParam(), Arrays.asList(request.toFileParam()), VideoPublishResponse.class);
    }

    public CreateVideoResponse createVideo(CreateVideoRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        CreateVideoResponse response = new CreateVideoResponse();
        StartUploadRequest startUploadRequest = new StartUploadRequest(request.getAccessToken());
        StartUploadResponse startUploadResponse = this.startUpload(startUploadRequest);
        UploadFileRequest uploadFileRequest = new UploadFileRequest(startUploadResponse, request.getVideoFileData());
        this.uploadFile(uploadFileRequest);
        VideoPublishRequest videoPublishRequest = new VideoPublishRequest(request, startUploadResponse);
        VideoPublishResponse videoPublishResponse = this.videoPublish(videoPublishRequest);
        response.setResult(videoPublishResponse.getResult());
        response.setVideoInfo(videoPublishResponse.getVideoInfo());
        return response;
    }

    public VideoListResponse queryVideoList(VideoListRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/openapi/photo/list", request.toQueryParam(this), VideoListResponse.class);
    }

    public VideoInfoResponse queryVideoInfo(VideoInfoRequest request) throws KwaiOpenException {
        ValidatorUtils.valid(request);
        return HttpUtils.get("https://open.kuaishou.com/openapi/photo/info", request.toQueryParam(this), VideoInfoResponse.class);
    }
}

