/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.login.kwailogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.kwai.auth.KwaiAuthAPI;
import com.kwai.auth.common.InternalRequest;
import com.kwai.auth.common.KwaiConstants;
import com.kwai.auth.login.kwailogin.applogin.LoginRequest;
import com.kwai.auth.login.kwailogin.h5login.H5LoginRequest;
import com.kwai.auth.utils.ResourceManager;

public class KwaiAuthRequest {
    private static final String TAG = "GameKwaiLoginRequest";
    private InternalRequest mRequest;
    private String appId;
    private String scope;
    private String state;
    private String authType;
    @KwaiConstants.LoginType
    private int loginType;
    @KwaiConstants.Platform
    private String[] platformArray;

    private KwaiAuthRequest() {
    }

    private void createRequest() {
        switch (this.loginType) {
            case 1: {
                this.mRequest = new LoginRequest(this.scope, this.state, this.authType);
                break;
            }
            case 2: {
                this.mRequest = new H5LoginRequest(this.scope, this.state, this.authType);
                break;
            }
        }
        this.mRequest.setAppId(this.appId);
    }

    public boolean execute(final KwaiAuthAPI kwaiAuthAPI, final Activity activity, final @KwaiConstants.Platform String platform) {
        if (activity == null || activity.isFinishing()) {
            return false;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                int requestCode = 0;
                Intent intent = KwaiAuthRequest.this.mRequest.buildIntent(activity, platform);
                Bundle bundle = new Bundle();
                KwaiAuthRequest.this.toBundle(activity, bundle);
                intent.putExtras(bundle);
                try {
                    if (activity.isFinishing()) {
                        Log.e((String)KwaiAuthRequest.TAG, (String)"Please don't finish activity");
                        return;
                    }
                    activity.startActivityForResult(intent, requestCode);
                    if (KwaiAuthRequest.this.mRequest.hasForwardAnime()) {
                        activity.overridePendingTransition(ResourceManager.findAnimByName((Context)activity, "kwai_fade_in"), 0);
                    }
                }
                catch (Exception e) {
                    Log.e((String)KwaiAuthRequest.TAG, (String)"Kwai activity not found");
                    kwaiAuthAPI.getLoginListener().onFailed("fail", 0, "Kwai activity not found");
                }
            }
        });
        return true;
    }

    private void toBundle(Activity activity, Bundle bundle) {
        this.mRequest.setPackageName(activity.getPackageName());
        this.mRequest.toBundle(activity.getApplicationContext(), bundle);
    }

    public String getState() {
        return this.state;
    }

    public int getLoginType() {
        return this.loginType;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public void setLoginType(int loginType) {
        this.loginType = loginType;
    }

    public void setPlatformArray(@KwaiConstants.Platform String[] platformArray) {
        this.platformArray = platformArray;
    }

    @KwaiConstants.Platform
    public String[] getPlatformArray() {
        return this.platformArray;
    }

    public static final class Builder {
        private String state;
        @KwaiConstants.LoginType
        private int loginType;
        @KwaiConstants.AuthMode
        private String authMode;
        @KwaiConstants.Platform
        private String[] platformArray;

        public KwaiAuthRequest build() {
            KwaiAuthRequest request = new KwaiAuthRequest();
            String appId = KwaiAuthAPI.getInstance().getAppId();
            if (TextUtils.isEmpty((CharSequence)appId)) {
                throw new IllegalArgumentException("appId is empty, please set in build.gradle");
            }
            request.appId = appId;
            String scope = KwaiAuthAPI.getInstance().getAppScope();
            if (TextUtils.isEmpty((CharSequence)scope)) {
                throw new IllegalArgumentException("scope is empty");
            }
            request.scope = scope;
            if (TextUtils.isEmpty((CharSequence)this.state)) {
                throw new IllegalArgumentException("state is empty");
            }
            request.setState(this.state);
            if (this.loginType != 1 && this.loginType != 2) {
                throw new IllegalArgumentException("loginType is illegal");
            }
            request.setLoginType(this.loginType);
            if (!this.authMode.equals("code")) {
                throw new IllegalArgumentException("authMode is illegal");
            }
            request.setAuthType(this.authMode);
            if (this.platformArray == null || this.platformArray.length == 0) {
                this.platformArray = new String[]{"kwai_app"};
            }
            request.setPlatformArray(this.platformArray);
            request.createRequest();
            return request;
        }

        public Builder setState(String state) {
            this.state = state;
            return this;
        }

        public Builder setLoginType(@KwaiConstants.LoginType int loginType) {
            this.loginType = loginType;
            return this;
        }

        public Builder setAuthMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        public Builder setPlatformArray(@KwaiConstants.Platform String[] platformArray) {
            this.platformArray = platformArray;
            return this;
        }
    }
}

