/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.login.kwailogin.h5login;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.kwai.auth.common.InternalResponse;

public class H5LoginResponse
extends InternalResponse {
    private static final String LOGIN_RESPONSE_PROP_CODE = "code";
    private static final String LOGIN_RESPONSE_PROP_STATE = "STATE";
    private static final String LOGIN_RESPONSE_PROP_ACCESS_TOKEN = "access_token";
    private static final String LOGIN_RESPONSE_ERR_CODE = "result";
    private static final String LOGIN_RESPONSE_ERR_MSG = "error_msg";
    private static final String LOGIN_RESPONSE_IS_NEW_USER = "is_new_user";

    public H5LoginResponse(Intent intent) {
        String url;
        if (intent != null && !TextUtils.isEmpty((CharSequence)(url = intent.getStringExtra(LOGIN_RESPONSE_ERR_CODE)))) {
            try {
                Uri uri = Uri.parse((String)url);
                this.code = uri.getQueryParameter(LOGIN_RESPONSE_PROP_CODE);
                String resultStr = uri.getQueryParameter(LOGIN_RESPONSE_ERR_CODE);
                if (!TextUtils.isEmpty((CharSequence)resultStr) && TextUtils.isDigitsOnly((CharSequence)resultStr)) {
                    this.setErrorCode(Integer.parseInt(resultStr));
                }
                this.setErrorMsg(uri.getQueryParameter(LOGIN_RESPONSE_ERR_MSG));
                String isNewUserStr = uri.getQueryParameter(LOGIN_RESPONSE_IS_NEW_USER);
                this.setNewUser(Boolean.parseBoolean(isNewUserStr));
            }
            catch (Exception e) {
                Log.e((String)H5LoginResponse.class.getSimpleName(), (String)("H5LoginResponse init error:" + e.getMessage()));
            }
            this.state = intent.getStringExtra("state");
        }
    }

    @Override
    public boolean isSuccess() {
        return 0 == this.getErrorCode() && !TextUtils.isEmpty((CharSequence)this.code);
    }
}

