/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.login.kwailogin.h5login;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import com.kwai.auth.KwaiAuthAPI;
import com.kwai.auth.common.InternalResponse;
import com.kwai.auth.common.KwaiConstants;
import com.kwai.auth.login.kwailogin.h5login.H5LoginResponse;
import com.kwai.auth.utils.ResourceManager;

public class KwaiH5LoginActivity
extends Activity {
    private static final String TAG = "KwaiH5LoginActivity";
    public static final String EXTRA_URL = "extra_url";
    public static final String EXTRA_STATE = "extra_state";
    public static final String EXTRA_REQUEST_CODE = "extra_request_code";
    public static final int REQUEST_CODE_LOGIN = 1000;
    public static final int PROGRESS_BAR_MAX_VALUE = 100;
    private static final String CLOSE_URL = "kwai://opensdk/webview/close";
    private WebView mWebView;
    private ProgressBar mProgressBar;
    private String mUrl;
    private String mState;
    private int mRequestCode;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(ResourceManager.findLayoutByName((Context)this, "activity_kwai_login_h5"));
        this.processIntent(this.getIntent());
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            this.finish();
            return;
        }
        this.initView();
    }

    private void processIntent(Intent intent) {
        Bundle bundle;
        if (intent != null && (bundle = intent.getExtras()) != null) {
            this.mUrl = bundle.getString(EXTRA_URL);
            this.mState = bundle.getString(EXTRA_STATE);
            this.mRequestCode = bundle.getInt(EXTRA_REQUEST_CODE, 0);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.processIntent(intent);
        this.initView();
    }

    private void initView() {
        this.mWebView = (WebView)ResourceManager.findViewByName(this, "webview");
        this.mProgressBar = (ProgressBar)ResourceManager.findViewByName(this, "progressBar");
        View root = ResourceManager.findViewByName(this, "root_view");
        this.mProgressBar.setVisibility(0);
        this.mProgressBar.setMax(100);
        this.removeAllCookie();
        this.initWebView();
        this.mWebView.loadUrl(this.mUrl);
        this.mWebView.resumeTimers();
        root.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                KwaiAuthAPI.getInstance().handleResponse(KwaiH5LoginActivity.this.createCancelResponse(), KwaiH5LoginActivity.this);
            }
        });
    }

    private InternalResponse createCancelResponse() {
        H5LoginResponse response = new H5LoginResponse(null);
        response.setErrorCode(-1);
        return response;
    }

    public void onBackPressed() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        } else {
            super.onBackPressed();
        }
    }

    private void initWebView() {
        this.mWebView.setScrollBarStyle(0);
        this.mWebView.setOverScrollMode(2);
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.mWebView.getSettings().setSupportZoom(true);
        this.mWebView.getSettings().setBuiltInZoomControls(false);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDefaultTextEncodingName("UTF-8");
        this.mWebView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        this.mWebView.getSettings().setCacheMode(2);
        this.mWebView.getSettings().setSavePassword(false);
        this.mWebView.getSettings().setAllowFileAccess(false);
        this.mWebView.clearCache(true);
        this.mWebView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, final String url) {
                if (KwaiH5LoginActivity.this.mRequestCode == 1000) {
                    if (url.trim().toLowerCase().startsWith(KwaiConstants.getLoginRedirectUrl((Context)KwaiH5LoginActivity.this).trim().toLowerCase())) {
                        KwaiH5LoginActivity.this.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                Intent intent = new Intent();
                                intent.putExtra("result", url);
                                intent.putExtra("state", KwaiH5LoginActivity.this.mState);
                                KwaiAuthAPI.getInstance().handleResponse(new H5LoginResponse(intent), KwaiH5LoginActivity.this);
                            }
                        });
                        return true;
                    }
                    if (url.trim().toLowerCase().equals(KwaiH5LoginActivity.CLOSE_URL)) {
                        KwaiAuthAPI.getInstance().handleResponse(KwaiH5LoginActivity.this.createCancelResponse(), KwaiH5LoginActivity.this);
                        return true;
                    }
                }
                return super.shouldOverrideUrlLoading(view, url);
            }
        });
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onCloseWindow(WebView window) {
                super.onCloseWindow(window);
                KwaiH5LoginActivity.this.finish();
            }

            public void onProgressChanged(WebView view, int newProgress) {
                if (null == KwaiH5LoginActivity.this.mProgressBar) {
                    return;
                }
                if (newProgress == 100) {
                    KwaiH5LoginActivity.this.mProgressBar.setVisibility(8);
                } else {
                    KwaiH5LoginActivity.this.mProgressBar.setProgress(newProgress);
                    KwaiH5LoginActivity.this.mProgressBar.setVisibility(0);
                }
                super.onProgressChanged(view, newProgress);
            }
        });
    }

    private void removeAllCookie() {
        CookieSyncManager.createInstance((Context)this.mWebView.getContext());
        CookieManager.getInstance().removeAllCookie();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mWebView != null) {
            try {
                if (this.mWebView.getParent() != null) {
                    ((ViewGroup)this.mWebView.getParent()).removeView((View)this.mWebView);
                }
                this.mWebView.clearHistory();
                this.mWebView.clearCache(true);
                this.mWebView.loadUrl("about:blank");
                this.mWebView.freeMemory();
                this.mWebView.destroy();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            this.mWebView = null;
        }
    }
}

