/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

public final class PackageUtil {
    public static int getVersionCode(Context context) {
        return PackageUtil.getVersionCode(context, context.getPackageName());
    }

    public static int getVersionCode(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return 0;
        }
        int versionCode = 0;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionCode = packageInfo.versionCode;
            return versionCode;
        }
        catch (Exception e) {
            Log.e((String)"PackageUtil", (String)e.getMessage());
            return versionCode;
        }
    }

    public static String getPackageVersion(Context context) {
        return PackageUtil.getPackageVersion(context, context.getPackageName());
    }

    public static String getPackageVersion(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        String versionName = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionName = packageInfo.versionName;
            if (TextUtils.isEmpty((CharSequence)versionName)) {
                return null;
            }
        }
        catch (Exception e) {
            Log.e((String)"PackageUtil", (String)e.getMessage());
        }
        return versionName;
    }

    private static Signature[] getPackageSignature(Context context, String packageName) {
        PackageInfo localPackageInfo;
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        PackageManager localPackageManager = context.getPackageManager();
        try {
            localPackageInfo = localPackageManager.getPackageInfo(packageName, 64);
            if (localPackageInfo == null) {
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException localNameNotFoundException) {
            Log.e((String)"PackageUtil", (String)localNameNotFoundException.getMessage());
            return null;
        }
        return localPackageInfo.signatures;
    }

    public static int getAppSupportAPILevel(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return 0;
        }
        try {
            int apiLevel = 0;
            Bundle meta = context.getPackageManager().getApplicationInfo((String)packageName, (int)128).metaData;
            if (meta != null) {
                apiLevel = meta.getInt("authorizationSdkVersionNumber", 0);
            }
            Log.i((String)"Kwai Open Sdk", (String)("kwai api level is " + apiLevel));
            return apiLevel;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Kwai Open Sdk", (String)("get kwai api level failed, " + (Object)((Object)e)));
            return 0;
        }
    }

    public static boolean isAppPackageInstalled(Context context, String packageName) {
        PackageInfo packageInfo;
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
        }
        return packageInfo != null;
    }

    public static boolean validateSignature(Context context, String packageName, String appSignature) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName) || TextUtils.isEmpty((CharSequence)appSignature)) {
            return false;
        }
        Signature[] arrayOfSignature = PackageUtil.getPackageSignature(context, packageName);
        if (arrayOfSignature == null || arrayOfSignature.length == 0) {
            Log.e((String)"Kwai Open Sdk", (String)"Get signature failed");
            return false;
        }
        for (int i = 0; i < arrayOfSignature.length; ++i) {
            String signature = arrayOfSignature[i].toCharsString().toLowerCase();
            if (!appSignature.equals(signature)) continue;
            return true;
        }
        Log.e((String)"Kwai Open Sdk", (String)"Signature check failed.");
        return false;
    }
}

