/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.model.base;

import android.os.Bundle;
import com.kwai.opensdk.sdk.constants.KwaiOpenSdkCmdEnum;
import com.kwai.opensdk.sdk.constants.KwaiPlatform;
import com.kwai.opensdk.sdk.utils.BundleUtil;
import java.util.ArrayList;

public abstract class BaseReq {
    public String transaction;
    public String sessionId;
    public String thirdExtraInfo;
    @KwaiPlatform.Platform
    private String[] platformArray;

    public abstract KwaiOpenSdkCmdEnum getCommand();

    public void toBundle(Bundle b) {
        b.putString("kwai_bundle_command", this.getCommand().getCmdString());
        b.putString("kwai_bundle_transaction", this.transaction);
        b.putString("kwai_bundle_session_id", this.sessionId);
        b.putString("kwai_bundle_third_extra_info", this.thirdExtraInfo);
    }

    public void fromBundle(Bundle b) {
        this.transaction = BundleUtil.getStringExtra(b, "kwai_bundle_transaction");
        this.sessionId = BundleUtil.getStringExtra(b, "kwai_bundle_session_id");
        this.thirdExtraInfo = BundleUtil.getStringExtra(b, "kwai_bundle_third_extra_info");
    }

    public abstract boolean checkArgs();

    public abstract String getBundleKey();

    @KwaiPlatform.Platform
    public String[] getPlatformArray() {
        if (this.platformArray == null || this.platformArray.length == 0) {
            this.platformArray = new String[]{"kwai_app"};
        } else {
            ArrayList<String> platformList = new ArrayList<String>(2);
            for (String platform : this.platformArray) {
                if (!"kwai_app".equals(platform) && !"nebula_app".equals(platform)) continue;
                platformList.add(platform);
            }
            int size = platformList.size();
            this.platformArray = size > 0 ? platformList.toArray(new String[size]) : new String[]{"kwai_app"};
        }
        return this.platformArray;
    }

    public void setPlatformArray(@KwaiPlatform.Platform String[] platformArray) {
        this.platformArray = platformArray;
    }
}

