/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.model.postshare;

import android.os.Bundle;
import com.kwai.opensdk.sdk.constants.KwaiOpenSdkCmdEnum;
import com.kwai.opensdk.sdk.model.base.BaseReq;
import com.kwai.opensdk.sdk.model.base.BaseResp;
import com.kwai.opensdk.sdk.model.postshare.FileTypeUtil;
import com.kwai.opensdk.sdk.model.postshare.PostShareMediaInfo;
import com.kwai.opensdk.sdk.model.postshare.plc.AbstractPlcBindInfo;
import com.kwai.opensdk.sdk.model.postshare.plc.PlcBindInfoFactory;
import java.io.File;

public class SingleVideoClip {

    public static class Resp
    extends BaseResp {
        public Resp() {
        }

        public Resp(Bundle b) {
            this.fromBundle(b);
        }

        @Override
        public KwaiOpenSdkCmdEnum getCommand() {
            return KwaiOpenSdkCmdEnum.CMD_SINGLE_VIDEO_CLIP;
        }

        @Override
        public boolean checkArgs() {
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        public PostShareMediaInfo mediaInfo;
        public AbstractPlcBindInfo mPlcBindInfo;
        private int mPage = 1;

        public Req() {
        }

        public Req(Bundle b) {
            this.fromBundle(b);
        }

        @Override
        public KwaiOpenSdkCmdEnum getCommand() {
            return KwaiOpenSdkCmdEnum.CMD_SINGLE_VIDEO_CLIP;
        }

        @Override
        public void toBundle(Bundle b) {
            Bundle msgBundle = PostShareMediaInfo.Builder.toBundle(this.mediaInfo);
            super.toBundle(msgBundle);
            b.putAll(msgBundle);
            b.putInt("targetPage", this.mPage);
            if (this.mPlcBindInfo != null) {
                this.mPlcBindInfo.toBundle(b);
            }
        }

        @Override
        public void fromBundle(Bundle b) {
            super.fromBundle(b);
            this.mediaInfo = PostShareMediaInfo.Builder.fromBundle(b);
            this.mPlcBindInfo = PlcBindInfoFactory.fromBundle(b);
        }

        public int getPage() {
            return this.mPage;
        }

        @Override
        public boolean checkArgs() {
            return this.mediaInfo != null && this.mediaInfo.checkArgs() && (this.mediaInfo.isUseMediaUri() || this.isMediaFile() && this.isMediaFileExist());
        }

        @Override
        public String getBundleKey() {
            return this.getCommand().getBundleKey();
        }

        private boolean isMediaFile() {
            if (this.mediaInfo.mMultiMediaAssets == null || this.mediaInfo.mMultiMediaAssets.size() == 0) {
                return false;
            }
            boolean isMedia = true;
            if (this.mediaInfo.mMultiMediaAssets != null && this.mediaInfo.mMultiMediaAssets.size() > 0) {
                for (String item : this.mediaInfo.mMultiMediaAssets) {
                    if (FileTypeUtil.isVideoFile(item)) {
                        isMedia = true;
                        continue;
                    }
                    isMedia = false;
                    break;
                }
            }
            return isMedia;
        }

        private boolean isMediaFileExist() {
            if (this.mediaInfo.mMultiMediaAssets == null || this.mediaInfo.mMultiMediaAssets.size() == 0) {
                return false;
            }
            boolean isFileExist = true;
            if (this.mediaInfo.mMultiMediaAssets != null && this.mediaInfo.mMultiMediaAssets.size() > 0) {
                for (String item : this.mediaInfo.mMultiMediaAssets) {
                    if (new File(item).exists()) continue;
                    isFileExist = false;
                    break;
                }
            }
            return isFileExist;
        }
    }
}

