/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.openapi;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kwai.opensdk.sdk.LoadingActivity;
import com.kwai.opensdk.sdk.constants.KwaiOpenSdkCmdEnum;
import com.kwai.opensdk.sdk.constants.KwaiPlatform;
import com.kwai.opensdk.sdk.model.base.BaseReq;
import com.kwai.opensdk.sdk.model.base.BaseResp;
import com.kwai.opensdk.sdk.model.base.OpenSdkConfig;
import com.kwai.opensdk.sdk.model.postshare.AICutMedias;
import com.kwai.opensdk.sdk.model.postshare.MultiMediaClip;
import com.kwai.opensdk.sdk.model.postshare.MultiPictureEdit;
import com.kwai.opensdk.sdk.model.postshare.SinglePictureEdit;
import com.kwai.opensdk.sdk.model.postshare.SinglePicturePublish;
import com.kwai.opensdk.sdk.model.postshare.SingleVideoClip;
import com.kwai.opensdk.sdk.model.postshare.SingleVideoEdit;
import com.kwai.opensdk.sdk.model.postshare.SingleVideoPublish;
import com.kwai.opensdk.sdk.model.socialshare.ShareMessage;
import com.kwai.opensdk.sdk.model.socialshare.ShareMessageToBuddy;
import com.kwai.opensdk.sdk.model.socialshare.ShowProfile;
import com.kwai.opensdk.sdk.openapi.EventListenerManager;
import com.kwai.opensdk.sdk.openapi.IKwaiAPIEventListener;
import com.kwai.opensdk.sdk.openapi.IKwaiOpenAPI;
import com.kwai.opensdk.sdk.utils.AppInfoUtil;
import com.kwai.opensdk.sdk.utils.KwaiPlatformUtil;
import com.kwai.opensdk.sdk.utils.LogUtil;
import com.kwai.opensdk.sdk.utils.MarketUtil;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;

public class KwaiOpenAPI
implements IKwaiOpenAPI {
    private static final String TAG = "KwaiOpenAPIImpl";
    private Context mContext;
    private String mAppId;
    private String mSessionId;
    private volatile OpenSdkConfig mOpenSdkConfig;
    public static volatile boolean isKwaiOpenApiInit = false;

    public KwaiOpenAPI(@NonNull Context context) {
        this.mContext = context;
        this.mSessionId = String.valueOf(System.currentTimeMillis());
        this.initAppId(context);
        isKwaiOpenApiInit = true;
    }

    @Override
    public boolean sendReq(BaseReq req, Activity activity) {
        Intent intent;
        if (this.mContext == null) {
            throw new IllegalArgumentException("context must be initialized in constructor.");
        }
        if (this.mAppId == null) {
            throw new IllegalArgumentException("appId is empty, please set in meta-data.");
        }
        String platform = this.getReqToKwaiPlatform(req);
        if (TextUtils.isEmpty((CharSequence)platform)) {
            return false;
        }
        if (this.getKwaiConfig().isShowDefaultLoading()) {
            intent = new Intent(this.mContext, LoadingActivity.class);
            intent.putExtra("cmd_bundle_key", req.getCommand().getCmdString());
            intent.putExtra("kwai_config_key", (Serializable)this.getKwaiConfig());
            intent.putExtra("kwai_platform_key", platform);
        } else {
            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)KwaiPlatformUtil.getPlatformScheme(platform)));
            intent.setPackage(KwaiPlatformUtil.getPlatformPackageName(platform));
            intent.addCategory("android.intent.category.DEFAULT");
            if (this.getKwaiConfig().isSetNewTaskFlag()) {
                intent.addFlags(0x10000000);
                if (this.getKwaiConfig().isSetClearTaskFlag()) {
                    intent.addFlags(32768);
                }
            }
        }
        Bundle baseBundle = this.generateBaseBundle();
        baseBundle.putString("kwai_open_sdk_version", "unspecified");
        intent.putExtra("kwai_bundle_app_info_params", baseBundle);
        Bundle reqBundle = new Bundle();
        req.toBundle(reqBundle);
        intent.putExtra(req.getBundleKey(), reqBundle);
        intent.putExtra("kwai_bundle_req_type", req.getCommand().getType());
        Bundle configBundle = new Bundle();
        this.getKwaiConfig().toBundle(configBundle);
        intent.putExtra("kwai_bundle_config_params", configBundle);
        try {
            if (activity != null) {
                activity.startActivity(intent);
            } else {
                intent.addFlags(0x10000000);
                this.mContext.startActivity(intent);
            }
        }
        catch (ActivityNotFoundException e) {
            LogUtil.e("KwaiOpenSdk", "not found activity, " + (Object)((Object)e));
            return false;
        }
        catch (SecurityException e) {
            LogUtil.e("KwaiOpenSdk", "security exception, " + e);
            return false;
        }
        return true;
    }

    public Bundle generateBaseBundle() {
        Bundle baseBundle = new Bundle();
        baseBundle.putString("kwai_bundle_app_id", this.mAppId);
        baseBundle.putString("kwai_bundle_app_name", AppInfoUtil.getAppName(this.mContext));
        baseBundle.putString("kwai_bundle_calling_package_name", AppInfoUtil.getPackageName(this.mContext));
        return baseBundle;
    }

    @Override
    public void handleIntent(Intent intent) {
        if (intent != null && intent.hasExtra("kwai_bundle_command")) {
            String cmd = intent.getStringExtra("kwai_bundle_command");
            BaseResp resp = null;
            switch (KwaiOpenSdkCmdEnum.getOpenSdkCmd(cmd)) {
                case CMD_SHARE_MESSAGE: {
                    resp = new ShareMessage.Resp(intent.getExtras());
                    break;
                }
                case CMD_SHARE_MESSAGE_TO_BUDDY: {
                    resp = new ShareMessageToBuddy.Resp(intent.getExtras());
                    break;
                }
                case CMD_SHOW_PROFILE: {
                    resp = new ShowProfile.Resp(intent.getExtras());
                    break;
                }
                case CMD_SINGLE_PICTURE_EDIT: {
                    resp = new SinglePictureEdit.Resp(intent.getExtras());
                    break;
                }
                case CMD_SINGLE_PICTURE_PUBLISH: {
                    resp = new SinglePicturePublish.Resp(intent.getExtras());
                    break;
                }
                case CMD_SINGLE_VIDEO_EDIT: {
                    resp = new SingleVideoEdit.Resp(intent.getExtras());
                    break;
                }
                case CMD_SINGLE_VIDEO_PUBLISH: {
                    resp = new SingleVideoPublish.Resp(intent.getExtras());
                    break;
                }
                case CMD_SINGLE_VIDEO_CLIP: {
                    resp = new SingleVideoClip.Resp(intent.getExtras());
                    break;
                }
                case CMD_MULTI_MEDIA_CLIP: {
                    resp = new MultiMediaClip.Resp(intent.getExtras());
                    break;
                }
                case CMD_AI_CUT_MEDIAS: {
                    resp = new AICutMedias.Resp(intent.getExtras());
                    break;
                }
                case CMD_MULTI_PICTURE_EDIT: {
                    resp = new MultiPictureEdit.Resp(intent.getExtras());
                    break;
                }
            }
            this.notifyResp(resp);
        }
    }

    @Override
    public void addKwaiAPIEventListerer(@NonNull IKwaiAPIEventListener listerer) {
        EventListenerManager.addListener(this.mSessionId, new SoftReference<IKwaiAPIEventListener>(listerer));
    }

    @Override
    public void removeKwaiAPIEventListerer() {
        EventListenerManager.clearListener(this.mSessionId);
    }

    @Override
    public String getOpenAPISessionId() {
        return this.mSessionId;
    }

    @Override
    public void setOpenSdkConfig(OpenSdkConfig openSdkConfig) {
        this.mOpenSdkConfig = openSdkConfig;
    }

    @Override
    public void updateKwaiAppId(@NonNull String appId) {
        this.mAppId = appId;
    }

    @Override
    public boolean isAppSupportUri(Context context, BaseReq req) {
        String packageName = KwaiPlatformUtil.getPackageNameByReq(context, req);
        return KwaiPlatformUtil.isAppSupportUri(this.mContext, packageName);
    }

    @Override
    public boolean isAppSupportEditMultiPicture(Context context, BaseReq req) {
        String packageName = KwaiPlatformUtil.getPackageNameByReq(context, req);
        return KwaiPlatformUtil.isAppSupportEditMultiPicture(this.mContext, packageName);
    }

    private void notifyResp(BaseResp resp) {
        if (!resp.checkArgs()) {
            resp.errorCode = -1010;
            resp.errorMsg = "Please set correct resp params";
        }
        LogUtil.d(TAG, "notifyResp: resp.errorCode=" + resp.errorCode + " resp.errorMsg=" + resp.errorMsg);
        SoftReference<IKwaiAPIEventListener> listener = EventListenerManager.getListener(resp.sessionId);
        if (null != listener && null != listener.get()) {
            listener.get().onRespResult(resp);
        }
    }

    private BaseResp getEmptyResp(BaseReq req) {
        BaseResp resp = null;
        switch (req.getCommand()) {
            case CMD_SHARE_MESSAGE: {
                resp = new ShareMessage.Resp();
                break;
            }
            case CMD_SHARE_MESSAGE_TO_BUDDY: {
                resp = new ShareMessageToBuddy.Resp();
                break;
            }
            case CMD_SHOW_PROFILE: {
                resp = new ShowProfile.Resp();
                break;
            }
            case CMD_SINGLE_PICTURE_PUBLISH: {
                resp = new SinglePicturePublish.Resp();
                break;
            }
            case CMD_SINGLE_PICTURE_EDIT: {
                resp = new SinglePictureEdit.Resp();
                break;
            }
            case CMD_SINGLE_VIDEO_PUBLISH: {
                resp = new SingleVideoPublish.Resp();
                break;
            }
            case CMD_SINGLE_VIDEO_EDIT: {
                resp = new SingleVideoEdit.Resp();
                break;
            }
            case CMD_SINGLE_VIDEO_CLIP: {
                resp = new SingleVideoClip.Resp();
                break;
            }
            case CMD_MULTI_MEDIA_CLIP: {
                resp = new MultiMediaClip.Resp();
                break;
            }
            case CMD_AI_CUT_MEDIAS: {
                resp = new AICutMedias.Resp();
                break;
            }
            case CMD_MULTI_PICTURE_EDIT: {
                resp = new MultiPictureEdit.Resp();
            }
        }
        if (resp != null) {
            resp.transaction = req.transaction;
            resp.sessionId = this.mSessionId;
        }
        return resp;
    }

    @KwaiPlatform.Platform
    @Nullable
    private String getReqToKwaiPlatform(BaseReq req) {
        BaseResp resp = this.getEmptyResp(req);
        if (req == null || !req.checkArgs()) {
            resp.errorCode = -1010;
            resp.errorMsg = "Please set correct req params";
            this.notifyResp(resp);
            return null;
        }
        ArrayList<String> appValidatedList = KwaiPlatformUtil.validateAppInstalled(this.mContext, req.getPlatformArray());
        if (appValidatedList.isEmpty()) {
            resp.errorCode = -1005;
            resp.errorMsg = "Please install latest kwai app";
            this.notifyResp(resp);
            if (this.getKwaiConfig().isGoToMargetAppNotInstall()) {
                MarketUtil.gotoMarket(this.mContext, KwaiPlatformUtil.getPlatformPackageName(req.getPlatformArray()[0]));
            }
            return null;
        }
        ArrayList<String> appSupportAPIMatchedList = KwaiPlatformUtil.matchSupportAPI(this.mContext, appValidatedList);
        if (appSupportAPIMatchedList.isEmpty()) {
            resp.errorCode = -1006;
            resp.errorMsg = "Please install latest kwai app that support kwai open social api";
            this.notifyResp(resp);
            if (this.getKwaiConfig().isGoToMargetAppVersionNotSupport()) {
                MarketUtil.gotoMarket(this.mContext, KwaiPlatformUtil.getPlatformPackageName(req.getPlatformArray()[0]));
            }
            return null;
        }
        return appSupportAPIMatchedList.get(0);
    }

    private void initAppId(Context context) {
        if (TextUtils.isEmpty((CharSequence)this.mAppId)) {
            try {
                ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
                this.mAppId = appInfo.metaData.getString("APP_ID");
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private OpenSdkConfig getKwaiConfig() {
        if (this.mOpenSdkConfig == null) {
            this.mOpenSdkConfig = new OpenSdkConfig.Builder().build();
        }
        return this.mOpenSdkConfig;
    }
}

