/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import android.content.Context;
import androidx.annotation.NonNull;
import com.kwai.opensdk.sdk.constants.KwaiPlatform;
import com.kwai.opensdk.sdk.model.base.BaseReq;
import com.kwai.opensdk.sdk.utils.AppPackageUtil;
import java.util.ArrayList;
import java.util.Iterator;

public class KwaiPlatformUtil {
    public static final String KWAI_APP_PACKAGE_NAME = "com.smile.gifmaker";
    public static final String NEBULA_PACKAGE_NAME = "com.kuaishou.nebula";
    public static final String KWAI_APP_SCHEME = "kwai://openapi";
    public static final String NEBULA_SCHEME = "ksnebula://openapi";
    private static String SIGNATURE = "3082024f308201b8a00302010202044e269662300d06092a864886f70d0101050500306b310b300906035504061302434e3110300e060355040813076265696a696e673110300e060355040713076265696a696e6731133011060355040a130a686563616f2e696e666f31133011060355040b130a686563616f2e696e666f310e300c0603550403130563616f68653020170d3131303732303038343833345a180f32303636303432323038343833345a306b310b300906035504061302434e3110300e060355040813076265696a696e673110300e060355040713076265696a696e6731133011060355040a130a686563616f2e696e666f31133011060355040b130a686563616f2e696e666f310e300c0603550403130563616f686530819f300d06092a864886f70d010101050003818d003081890281810093bce2a30779500e3a3160ce5b557f3fa34df50df25ac1ae38c181c8ad94e4709d00afbc532d27ccfd4a92c8f1bd5b19c1f04f37b8230020035e33eb39de2d482ad4c043f251fb08007cb3eac4a348e140a817784195f0fbafc7480c90f76ef966d220abd9c4ab3d246276c98ce6d77a7fcc4f451ae89eb387d9bff521898d970203010001300d06092a864886f70d0101050500038181001ce4eb9f42d76dfc4e0f5da07bc3efae2cf98b47a39790d35407f3aeb6b554cadd65e84c7252046b3ab72b2dfc86f0892e28fee3e6e4e801093e3a4f29bc560762d33839ceb29385583ded64548f245977d61925543dda7ac3d34e8153a88f9846f446ff96d4877ad808280bbd7c43b9bf5feea3dd8d6bd179bc8cf29f949163";

    public static ArrayList<String> validateAppInstalled(Context context, @KwaiPlatform.Platform String[] platformArray) {
        ArrayList<String> platformList = new ArrayList<String>(2);
        String[] stringArray = platformArray;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String platform;
            switch (platform = stringArray[i]) {
                case "kwai_app": {
                    if (!KwaiPlatformUtil.isAppValidated(context, KWAI_APP_PACKAGE_NAME, SIGNATURE)) continue block8;
                    platformList.add("kwai_app");
                    continue block8;
                }
                case "nebula_app": {
                    if (!KwaiPlatformUtil.isAppValidated(context, NEBULA_PACKAGE_NAME, SIGNATURE)) continue block8;
                    platformList.add("nebula_app");
                    continue block8;
                }
            }
        }
        return platformList;
    }

    public static ArrayList<String> matchSupportAPI(@NonNull Context context, @NonNull ArrayList<String> appValidatedList) {
        ArrayList<String> platformList = new ArrayList<String>(2);
        Iterator<String> iterator = appValidatedList.iterator();
        while (iterator.hasNext()) {
            String platform;
            switch (platform = iterator.next()) {
                case "kwai_app": {
                    if (!KwaiPlatformUtil.isAppSupportAPI(context, KWAI_APP_PACKAGE_NAME)) break;
                    platformList.add("kwai_app");
                    break;
                }
                case "nebula_app": {
                    if (!KwaiPlatformUtil.isAppSupportAPI(context, NEBULA_PACKAGE_NAME)) break;
                    platformList.add("nebula_app");
                    break;
                }
            }
        }
        return platformList;
    }

    private static boolean isAppValidated(@NonNull Context context, @NonNull String packageName, @NonNull String signature) {
        return AppPackageUtil.isAppPackageInstalled(context, packageName) && AppPackageUtil.validateSignature(context, packageName, signature);
    }

    private static boolean isAppSupportAPI(@NonNull Context context, @NonNull String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 1;
    }

    public static String getPackageNameByReq(@NonNull Context context, @NonNull BaseReq req) {
        ArrayList<String> appValidatedList = KwaiPlatformUtil.validateAppInstalled(context, req.getPlatformArray());
        if (appValidatedList.isEmpty()) {
            return null;
        }
        ArrayList<String> appSupportAPIMatchedList = KwaiPlatformUtil.matchSupportAPI(context, appValidatedList);
        if (appSupportAPIMatchedList.isEmpty()) {
            return null;
        }
        return KwaiPlatformUtil.getPlatformPackageName(appSupportAPIMatchedList.get(0));
    }

    public static boolean isAppSupportUri(@NonNull Context context, String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 2;
    }

    public static boolean isAppSupportEditMultiPicture(@NonNull Context context, String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 3;
    }

    public static String getPlatformPackageName(@KwaiPlatform.Platform String platform) {
        if ("kwai_app".equals(platform)) {
            return KWAI_APP_PACKAGE_NAME;
        }
        if ("nebula_app".equals(platform)) {
            return NEBULA_PACKAGE_NAME;
        }
        return null;
    }

    public static String getPlatformScheme(@KwaiPlatform.Platform String platform) {
        if ("kwai_app".equals(platform)) {
            return KWAI_APP_SCHEME;
        }
        if ("nebula_app".equals(platform)) {
            return NEBULA_SCHEME;
        }
        return null;
    }
}

