/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.kwai.auth.ILoginListener;
import com.kwai.auth.common.InternalResponse;
import com.kwai.auth.common.KwaiConstants;
import com.kwai.auth.login.kwailogin.KwaiAuthRequest;
import com.kwai.auth.utils.LogUtil;
import com.kwai.auth.utils.PlatformUtil;
import java.util.ArrayList;

public final class KwaiAuthAPI {
    private static final String TAG = "KwaiApi";
    private static Application sContext;
    private ILoginListener mLoginListener;
    private static KwaiAuthAPI sKwaiAuthAPI;
    private boolean mTestEnv;
    private static String sAppId;
    private static String sAppScope;
    @KwaiConstants.Platform
    private static String sPlatform;

    private KwaiAuthAPI() {
    }

    public static void init(Application mContext) {
        sContext = mContext;
        sKwaiAuthAPI = new KwaiAuthAPI();
    }

    public static void enableDebugLog() {
        LogUtil.enableLog();
    }

    @NonNull
    public static KwaiAuthAPI getInstance() {
        if (sKwaiAuthAPI == null) {
            throw new IllegalStateException("KwaiAuthAPI not init.");
        }
        return sKwaiAuthAPI;
    }

    private void checkInitState() {
        if (sContext == null) {
            throw new IllegalStateException("Kwai API must be initialized first when launching the app.");
        }
    }

    public boolean sendRequest(Activity activity, @NonNull KwaiAuthRequest request, ILoginListener loginListener) {
        if (request == null) {
            return false;
        }
        this.mLoginListener = loginListener;
        if (activity == null || activity.isFinishing()) {
            LogUtil.e(TAG, "Please don't finish activity");
            this.mLoginListener.onFailed(request.getState(), -1009, "CODE_FAIL_GHOST_ACTIVITY");
            return false;
        }
        if (this.needValidateApp(request)) {
            ArrayList<String> appValidatedList = PlatformUtil.validateAppInstalled((Context)sContext, request.getPlatformArray());
            if (appValidatedList.isEmpty()) {
                LogUtil.e(TAG, "Please install latest kwai app");
                this.mLoginListener.onFailed(request.getState(), -1005, "CODE_CANCEL_NO_APP");
                return false;
            }
            ArrayList<String> appSupportAPIMatchedList = PlatformUtil.matchSupportAPI((Context)sContext, appValidatedList);
            if (appSupportAPIMatchedList.isEmpty()) {
                LogUtil.e(TAG, "Please install latest kwai app that support kwai api");
                this.mLoginListener.onFailed(request.getState(), -1006, "CODE_CANCEL_APP_UNSUPPORT");
                return false;
            }
            sPlatform = appSupportAPIMatchedList.get(0);
        }
        if (request.execute(this, activity, sPlatform)) {
            return true;
        }
        this.mLoginListener.onFailed(request.getState(), -1008, "REQUEST_EXECUTE_FAIL");
        return false;
    }

    private boolean needValidateApp(KwaiAuthRequest request) {
        return request.getLoginType() == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleResponse(InternalResponse response, Activity kwaiHandlerActivity) {
        if (this.mLoginListener == null) {
            try {
                kwaiHandlerActivity.finish();
                LogUtil.e(TAG, "handleResponse mLoginListener == null");
            }
            catch (Exception e) {
                LogUtil.e(TAG, "handleResponse exception = " + e.getMessage());
            }
            finally {
                return false;
            }
        }
        if (response == null) {
            this.mLoginListener.onFailed("handleResponse fail", 0, "handleResponse fail, response == null");
            return false;
        }
        if (!this.checkCallingPackage(kwaiHandlerActivity)) {
            this.mLoginListener.onFailed(response.getState(), response.getErrorCode(), response.getErrorMsg());
            return false;
        }
        if (response.isSuccess()) {
            this.mLoginListener.onSuccess(response);
        } else if (response.getErrorCode() == -1) {
            this.mLoginListener.onCancel();
        } else {
            this.mLoginListener.onFailed(response.getState(), response.getErrorCode(), response.getErrorMsg());
        }
        kwaiHandlerActivity.finish();
        return true;
    }

    private boolean checkCallingPackage(Activity kwaiHandlerActvity) {
        if (!sContext.getPackageName().equals(kwaiHandlerActvity.getCallingPackage())) {
            String packageName = PlatformUtil.getPlatformPackageName(sPlatform);
            if (!TextUtils.isEmpty((CharSequence)packageName) && !packageName.equals(kwaiHandlerActvity.getCallingPackage())) {
                LogUtil.e(TAG, "Package name is " + kwaiHandlerActvity.getCallingPackage());
            }
            if (!PlatformUtil.isPlatformAppValidated((Context)sContext, sPlatform)) {
                LogUtil.e(TAG, "Signature wrong.");
                kwaiHandlerActvity.finish();
                return false;
            }
        }
        return true;
    }

    public boolean isTestEnv() {
        return this.mTestEnv;
    }

    public void setTestEnv(boolean testEnv) {
        this.mTestEnv = testEnv;
    }

    public ILoginListener getLoginListener() {
        return this.mLoginListener;
    }

    public String getAppId() {
        if (TextUtils.isEmpty((CharSequence)sAppId)) {
            String metaData = null;
            try {
                metaData = this.getAppMetaDataAsString((Context)sContext, "KWAI_APP_ID");
                sAppId = metaData.substring(7);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sAppId == null) {
                throw new NullPointerException("KWAI_APP_ID meta-data cannot be null or empty");
            }
        }
        return sAppId;
    }

    private String getAppMetaDataAsString(@NonNull Context context, String key) {
        String metaData = null;
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            metaData = appInfo.metaData.getString(key);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return metaData;
    }

    public boolean validateApp() {
        this.checkInitState();
        return PlatformUtil.isPlatformAppValidated((Context)sContext, "kwai_app");
    }

    static {
        sPlatform = "kwai_app";
    }
}

