/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import android.os.Bundle;
import com.kwai.opensdk.sdk.utils.LogUtil;
import java.util.ArrayList;

public class BundleUtil {
    public static int getIntExtra(Bundle bundle, String key, int defaultValue) {
        if (bundle != null) {
            try {
                return bundle.getInt(key, defaultValue);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getIntExtra exception:" + e.getMessage());
            }
        }
        return defaultValue;
    }

    public static String getStringExtra(Bundle bundle, String key) {
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getStringExtra exception:" + e.getMessage());
            }
        }
        return null;
    }

    public static byte[] getByteArrayExtra(Bundle bundle, String key) {
        if (bundle != null) {
            try {
                return bundle.getByteArray(key);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getByteArrayExtra exception:" + e.getMessage());
            }
        }
        return null;
    }

    public static ArrayList<String> getStringArrayListExtra(Bundle bundle, String key) {
        if (bundle != null) {
            try {
                return bundle.getStringArrayList(key);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getStringArrayListExtra exception:" + e.getMessage());
            }
        }
        return null;
    }

    public static boolean getBooleanExtra(Bundle bundle, String key) {
        if (bundle != null) {
            try {
                return bundle.getBoolean(key);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getBooleanExtra exception:" + e.getMessage());
            }
        }
        return false;
    }

    public static long getLongExtra(Bundle bundle, String key) {
        if (bundle != null) {
            try {
                return bundle.getLong(key);
            }
            catch (Exception e) {
                LogUtil.e("KwaiOpenSdk", "getLongExtra exception:" + e.getMessage());
            }
        }
        return 0L;
    }
}

