/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.constants;

public enum KwaiOpenSdkCmdEnum {
    CMD_SHARE_MESSAGE(1, "share_message", true, true, "social-ft", "kwai_bundle_share_message", "share_message"),
    CMD_SHARE_MESSAGE_TO_BUDDY(2, "share_message_to_buddy", true, true, "social-ft", "kwai_bundle_share_message_to_buddy", "share_message"),
    CMD_SHOW_PROFILE(3, "show_profile", true, true, "social-ft", "kwai_bundle_show_profile", "show_profile"),
    CMD_SINGLE_PICTURE_EDIT(4, "single_picture_edit", true, true, "post-ft", "kwai_bundle_post_single_picture_edit", "share_media"),
    CMD_SINGLE_PICTURE_PUBLISH(5, "single_picture_publish", true, true, "post-ft", "kwai_bundle_post_single_picture_publish", "share_media"),
    CMD_SINGLE_VIDEO_PUBLISH(6, "single_video_publish", true, true, "post-ft", "kwai_bundle_post_single_video_publish", "share_media"),
    CMD_SINGLE_VIDEO_EDIT(7, "single_video_edit", true, true, "post-ft", "kwai_bundle_post_single_video_edit", "share_media"),
    CMD_SINGLE_VIDEO_CLIP(8, "single_video_clip", true, true, "post-ft", "kwai_bundle_post_single_video_clip", "share_media"),
    CMD_MULTI_MEDIA_CLIP(9, "multi_media_clip", true, true, "post-ft", "kwai_bundle_post_multi_media_clip", "share_media"),
    CMD_AI_CUT_MEDIAS(10, "ai_cut_medias", true, true, "post-ft", "kwai_bundle_post_ai_cut_medias", "share_media"),
    CMD_MULTI_PICTURE_EDIT(11, "multi_picture_edit", true, true, "post-ft", "kwai_bundle_post_multi_picture_edit", "share_media"),
    CMD_MULTI_PICTURE_PUBLISH(12, "multi_picture_publish", true, true, "post-ft", "kwai_bundle_post_multi_picture_publish", "share_media");

    private String cmd;
    private int type;
    private String feature;
    private boolean isAuthCmd;
    private boolean isNeedLogin;
    private String bundleKey;
    private String verifyStr;

    private KwaiOpenSdkCmdEnum(int type, String cmd, boolean isAuthCmd, boolean isNeedLogin, String feature, String bundleKey, String verifyStr) {
        this.type = type;
        this.cmd = cmd;
        this.isAuthCmd = isAuthCmd;
        this.feature = feature;
        this.isNeedLogin = isNeedLogin;
        this.bundleKey = bundleKey;
        this.verifyStr = verifyStr;
    }

    public String getCmdString() {
        return this.cmd;
    }

    public int getType() {
        return this.type;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getBundleKey() {
        return this.bundleKey;
    }

    public boolean isAuthCmd() {
        return this.isAuthCmd;
    }

    public String getVerifyStr() {
        return this.verifyStr;
    }

    public boolean isNeedLogin() {
        return this.isNeedLogin;
    }

    public static KwaiOpenSdkCmdEnum getOpenSdkCmd(String cmd) {
        switch (cmd) {
            case "share_message": {
                return CMD_SHARE_MESSAGE;
            }
            case "share_message_to_buddy": {
                return CMD_SHARE_MESSAGE_TO_BUDDY;
            }
            case "show_profile": {
                return CMD_SHOW_PROFILE;
            }
            case "single_picture_edit": {
                return CMD_SINGLE_PICTURE_EDIT;
            }
            case "single_picture_publish": {
                return CMD_SINGLE_PICTURE_PUBLISH;
            }
            case "single_video_publish": {
                return CMD_SINGLE_VIDEO_PUBLISH;
            }
            case "single_video_edit": {
                return CMD_SINGLE_VIDEO_EDIT;
            }
            case "single_video_clip": {
                return CMD_SINGLE_VIDEO_CLIP;
            }
            case "multi_media_clip": {
                return CMD_MULTI_MEDIA_CLIP;
            }
            case "ai_cut_medias": {
                return CMD_AI_CUT_MEDIAS;
            }
            case "multi_picture_edit": {
                return CMD_MULTI_PICTURE_EDIT;
            }
            case "multi_picture_publish": {
                return CMD_MULTI_PICTURE_PUBLISH;
            }
        }
        return null;
    }

    public static KwaiOpenSdkCmdEnum getOpenSdkCmd(int type) {
        switch (type) {
            case 1: {
                return CMD_SHARE_MESSAGE;
            }
            case 2: {
                return CMD_SHARE_MESSAGE_TO_BUDDY;
            }
            case 3: {
                return CMD_SHOW_PROFILE;
            }
            case 4: {
                return CMD_SINGLE_PICTURE_EDIT;
            }
            case 5: {
                return CMD_SINGLE_PICTURE_PUBLISH;
            }
            case 6: {
                return CMD_SINGLE_VIDEO_PUBLISH;
            }
            case 7: {
                return CMD_SINGLE_VIDEO_EDIT;
            }
            case 8: {
                return CMD_SINGLE_VIDEO_CLIP;
            }
            case 9: {
                return CMD_MULTI_MEDIA_CLIP;
            }
            case 10: {
                return CMD_AI_CUT_MEDIAS;
            }
            case 11: {
                return CMD_MULTI_PICTURE_EDIT;
            }
            case 12: {
                return CMD_MULTI_PICTURE_PUBLISH;
            }
        }
        return null;
    }
}

