/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.model.postshare;

import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kwai.opensdk.sdk.model.postshare.livephoto.LivePhotoInfo;
import com.kwai.opensdk.sdk.model.postshare.media.ThirdMusicInfo;
import com.kwai.opensdk.sdk.utils.BundleUtil;
import com.kwai.opensdk.sdk.utils.UriUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PostShareMediaInfo {
    public ArrayList<String> mMultiMediaAssets;
    public String mTag;
    public boolean mDisableFallback;
    public String mM2uExtraInfo;
    public String mExtraInfo;
    @Nullable
    public Map<String, Object> mMediaInfoMap;
    @Nullable
    public HashMap<String, LivePhotoInfo> mLivePhotoInfoMap;
    @Nullable
    public ThirdMusicInfo mMusicInfo;

    public final boolean checkArgs() {
        return true;
    }

    public final boolean isUseMediaUri() {
        if (this.mMultiMediaAssets == null || this.mMultiMediaAssets.size() == 0) {
            return false;
        }
        boolean isMediaUri = false;
        for (String item : this.mMultiMediaAssets) {
            if (UriUtil.isUriString(Uri.parse((String)item))) {
                isMediaUri = true;
                continue;
            }
            isMediaUri = false;
            break;
        }
        return isMediaUri;
    }

    public static class Builder {
        public static Bundle toBundle(PostShareMediaInfo mediaInfo) {
            String value;
            Gson gson;
            Bundle bundle = new Bundle();
            bundle.putStringArrayList("multiMediaPaths", mediaInfo.mMultiMediaAssets);
            bundle.putString("tag", mediaInfo.mTag);
            bundle.putBoolean("forceTarget", mediaInfo.mDisableFallback);
            bundle.putString("m2uExtraInfo", mediaInfo.mM2uExtraInfo);
            bundle.putString("extraInfo", mediaInfo.mExtraInfo);
            if (mediaInfo.mMediaInfoMap != null && !mediaInfo.mMediaInfoMap.isEmpty()) {
                try {
                    gson = new GsonBuilder().create();
                    value = gson.toJson(mediaInfo.mMediaInfoMap);
                    bundle.putString("additionMediaInfo", value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mediaInfo.mLivePhotoInfoMap != null && !mediaInfo.mLivePhotoInfoMap.isEmpty()) {
                try {
                    gson = new GsonBuilder().create();
                    value = gson.toJson(mediaInfo.mLivePhotoInfoMap);
                    bundle.putString("additionLivePhotoInfo", value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mediaInfo.mMusicInfo != null) {
                try {
                    gson = new GsonBuilder().create();
                    value = gson.toJson((Object)mediaInfo.mMusicInfo);
                    bundle.putString("musicInfo", value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return bundle;
        }

        public static PostShareMediaInfo fromBundle(Bundle bundle) {
            Gson gson;
            String value;
            PostShareMediaInfo mediaInfo = new PostShareMediaInfo();
            mediaInfo.mMultiMediaAssets = BundleUtil.getStringArrayListExtra(bundle, "multiMediaPaths");
            mediaInfo.mTag = BundleUtil.getStringExtra(bundle, "tag");
            mediaInfo.mDisableFallback = BundleUtil.getBooleanExtra(bundle, "forceTarget");
            mediaInfo.mM2uExtraInfo = BundleUtil.getStringExtra(bundle, "m2uExtraInfo");
            mediaInfo.mExtraInfo = BundleUtil.getStringExtra(bundle, "extraInfo");
            try {
                value = BundleUtil.getStringExtra(bundle, "additionMediaInfo");
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    gson = new GsonBuilder().create();
                    mediaInfo.mMediaInfoMap = (Map)gson.fromJson(value, Map.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                value = BundleUtil.getStringExtra(bundle, "additionLivePhotoInfo");
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    Type type = new TypeToken<HashMap<String, LivePhotoInfo>>(){}.getType();
                    Gson gson2 = new GsonBuilder().create();
                    mediaInfo.mLivePhotoInfoMap = (HashMap)gson2.fromJson(value, type);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                value = BundleUtil.getStringExtra(bundle, "musicInfo");
                if (!TextUtils.isEmpty((CharSequence)value)) {
                    gson = new GsonBuilder().create();
                    mediaInfo.mMusicInfo = (ThirdMusicInfo)gson.fromJson(value, ThirdMusicInfo.class);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return mediaInfo;
        }
    }
}

