/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.common;

import android.content.Context;
import com.kwai.auth.KwaiAuthAPI;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class KwaiConstants {
    public static final String VERSION_CODE = "";
    public static final String EXTRA_URL = "extra_url";
    public static final String EXTRA_TITLE = "extra_title";
    public static final String EXTRA_REQUEST_CODE = "extra_request_code";
    public static final String EXTRA_NEED_SHOW_TITLE = "extra_need_show_title";
    public static final String EXTRA_LOAD_URL_METHOD = "extra_load_url_method";
    public static final String EXTRA_POST_PARAM = "extra_post_param";
    public static final int METHOD_LOAD_URL = 0;
    public static final int METHOD_POST_URL = 1;
    public static final int REQUEST_CODE_LOGIN = 1000;
    public static final int REQUEST_CODE_WX_PAY = 1001;
    public static final int REQUEST_CODE_ALI_PAY = 1002;
    public static final int REQUEST_CODE_USER_CENTER = 1003;
    public static final int CODE_HTTP_SERVER_ERROR = 0;
    public static final int SUCCESS = 1;
    public static final int FAILURE = 0;
    public static final int CANCEL = -1;
    public static final int CODE_HTTP_ERROR_NO_NETWORK = -1000;
    public static final int CODE_HTTP_ERROR_PARAMETER_ERROR = -1001;
    public static final int CODE_HTTP_NETWORK_TIMEOUT = -10002;
    public static final int CODE_BIND_CANCEL_NO_TOKEN = -1003;
    public static final int CODE_BIND_CANCEL_TOKEN_EXPIRED = -1004;
    public static final int CODE_CANCEL_NO_APP = -1005;
    public static final int CODE_CANCEL_APP_UNSUPPORT = -1006;
    public static final int CODE_FAIL_APP_BAD_RETURN = -1007;
    public static final int CODE_REQUEST_EXECUTE_FAILED = -1008;
    public static final int CODE_FAIL_GHOST_ACTIVITY = -1009;
    public static final String KWAI_PACKAGE_NAME = "com.smile.gifmaker";
    private static final String KWAI_LOGIN_API_HOST_TEST = "https://open.test.gifshow.com";
    private static final String KWAI_LOGIN_API_HOST_ONLINE = "https://open.kuaishou.com";
    public static final String KWAI_APP_ID = "KWAI_APP_ID";

    public static String getLoginHost() {
        if (KwaiAuthAPI.getInstance().isTestEnv()) {
            return KWAI_LOGIN_API_HOST_TEST;
        }
        return KWAI_LOGIN_API_HOST_ONLINE;
    }

    public static String getWebLoginUrl(String appId, String type, String state, String scope, Context context) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(KwaiConstants.getLoginHost()).append("/oauth2/authorize?app_id=" + appId).append("&response_type=" + type).append("&state=" + state).append("&scope=" + scope).append("&webVersion=1").append("&redirect_uri=" + KwaiConstants.getLoginRedirectUrl(context));
        return stringBuilder.toString();
    }

    public static String getLoginRedirectUrl(Context context) {
        return context.getPackageName() + "://login/result";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Platform {
        public static final String KWAI_APP = "kwai_app";
        public static final String NEBULA_APP = "nebula_app";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface AuthMode {
        public static final String AUTHORIZE = "code";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LoginType {
        public static final int APP = 1;
        public static final int H5 = 2;
    }
}

