/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.login.kwailogin.applogin;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.kwai.auth.common.InternalRequest;
import com.kwai.auth.common.KwaiConstants;
import com.kwai.auth.login.kwailogin.applogin.AuthScopes;

public final class LoginRequest
extends InternalRequest {
    private static final String LOGIN_REQUEST_PROP_SCOPE = "kwai_request_scope";
    private static final String LOGIN_REQUEST_PROP_SCOPE_REQUIRED = "kwai_request_scopes_required";
    private static final String LOGIN_REQUEST_PROP_SCOPE_OPTIONAL0 = "login_request_prop_scope_optional0";
    private static final String LOGIN_REQUEST_PROP_SCOPE_OPTIONAL1 = "login_request_prop_scope_optional1";
    private static final String LOGIN_REQUEST_PROP_STATE = "kwai_state";
    private static final String LOGIN_REQUEST_PROP_TYPE = "kwai_request_type";
    private static final String LOGIN_REQUEST_PROP_SDK_VERSION = "kwai_request_sdk_version";
    private final AuthScopes mScopes;
    private String mScope;
    private String mState;
    private String mType;
    private final String mSdkVersion;

    public LoginRequest(AuthScopes scopes, String scope, String state, String authType, String sdkVersion) {
        this.mScopes = scopes;
        this.mScope = scope;
        this.mState = state;
        this.mType = authType;
        this.mSdkVersion = sdkVersion;
        this.forwardAnime = true;
    }

    @Override
    public String getCommand() {
        return "kwai.login";
    }

    @Override
    public Intent buildIntent(Activity activity, @KwaiConstants.Platform String platform) {
        if ("kwai_app".equals(platform)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"kwai://authorization"));
            intent.setPackage("com.smile.gifmaker");
            return intent;
        }
        if ("nebula_app".equals(platform)) {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)"ksnebula://authorization"));
            intent.setPackage("com.kuaishou.nebula");
            return intent;
        }
        throw new IllegalStateException("Platform must be corrected.");
    }

    @Override
    public void toBundle(Context context, Bundle bundle) {
        super.toBundle(context, bundle);
        bundle.putString(LOGIN_REQUEST_PROP_SCOPE_REQUIRED, this.mScopes.mScopeRequired);
        bundle.putString(LOGIN_REQUEST_PROP_SCOPE_OPTIONAL0, this.mScopes.mScopeOptional0);
        bundle.putString(LOGIN_REQUEST_PROP_SCOPE_OPTIONAL1, this.mScopes.mScopeOptional1);
        bundle.putString(LOGIN_REQUEST_PROP_SCOPE, this.mScope);
        bundle.putString(LOGIN_REQUEST_PROP_STATE, this.mState);
        bundle.putString(LOGIN_REQUEST_PROP_TYPE, this.mType);
        bundle.putString(LOGIN_REQUEST_PROP_SDK_VERSION, this.mSdkVersion);
    }
}

