/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.utils;

import android.text.TextUtils;
import androidx.annotation.NonNull;

class AppVersion
implements Comparable<AppVersion> {
    private final int major;
    private final int minor;
    private final int bugfix;
    private final int build;

    private AppVersion(int major, int minor, int bugfix, int build) {
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.build = build;
    }

    public static AppVersion of(int major, int minor, int bugfix, int build) {
        try {
            AppVersion.checkArgument(major >= 0);
            AppVersion.checkArgument(minor >= 0);
            AppVersion.checkArgument(bugfix >= 0);
            AppVersion.checkArgument(build >= 0);
            return new AppVersion(major, minor, bugfix, build);
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static AppVersion of(int major, int minor) {
        return AppVersion.of(major, minor, 0, 0);
    }

    public static AppVersion of(String ver) {
        if (TextUtils.isEmpty((CharSequence)ver)) {
            return null;
        }
        String[] split = ver.split("\\.");
        if (split.length < 2) {
            return null;
        }
        int major = AppVersion.safelyParseInt(split[0], 0);
        int minor = AppVersion.safelyParseInt(split[1], 0);
        int bugfix = split.length >= 3 ? AppVersion.safelyParseInt(split[2], 0) : 0;
        int build = split.length >= 4 ? AppVersion.safelyParseInt(split[3], 0) : 0;
        return AppVersion.of(major, minor, bugfix, build);
    }

    public static int compare(@NonNull AppVersion o1, @NonNull AppVersion o2) {
        int result = Integer.compare(o1.major, o2.major);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.minor, o2.minor);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.bugfix, o2.bugfix);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(o1.build, o2.build);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    @Override
    public int compareTo(AppVersion o) {
        return AppVersion.compare(this, o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bugfix;
        result = 31 * result + this.build;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppVersion)) {
            return false;
        }
        AppVersion other = (AppVersion)obj;
        if (this.bugfix != other.bugfix) {
            return false;
        }
        if (this.build != other.build) {
            return false;
        }
        if (this.major != other.major) {
            return false;
        }
        return this.minor == other.minor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.bugfix);
        if (this.build > 0) {
            sb.append('.').append(this.build);
        }
        return sb.toString();
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static int safelyParseInt(String string, int defaultValue) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return defaultValue;
        }
    }
}

