/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.auth.utils;

import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.kwai.auth.utils.AppVersion;
import com.kwai.auth.utils.LogUtil;
import java.util.Objects;

class KwaiSignature {
    private static final String TAG = "KwaiSignature";
    @NonNull
    private static final String V2 = "3082024f308201b8a00302010202044e269662300d06092a864886f70d0101050500306b310b300906035504061302434e3110300e060355040813076265696a696e673110300e060355040713076265696a696e6731133011060355040a130a686563616f2e696e666f31133011060355040b130a686563616f2e696e666f310e300c0603550403130563616f68653020170d3131303732303038343833345a180f32303636303432323038343833345a306b310b300906035504061302434e3110300e060355040813076265696a696e673110300e060355040713076265696a696e6731133011060355040a130a686563616f2e696e666f31133011060355040b130a686563616f2e696e666f310e300c0603550403130563616f686530819f300d06092a864886f70d010101050003818d003081890281810093bce2a30779500e3a3160ce5b557f3fa34df50df25ac1ae38c181c8ad94e4709d00afbc532d27ccfd4a92c8f1bd5b19c1f04f37b8230020035e33eb39de2d482ad4c043f251fb08007cb3eac4a348e140a817784195f0fbafc7480c90f76ef966d220abd9c4ab3d246276c98ce6d77a7fcc4f451ae89eb387d9bff521898d970203010001300d06092a864886f70d0101050500038181001ce4eb9f42d76dfc4e0f5da07bc3efae2cf98b47a39790d35407f3aeb6b554cadd65e84c7252046b3ab72b2dfc86f0892e28fee3e6e4e801093e3a4f29bc560762d33839ceb29385583ded64548f245977d61925543dda7ac3d34e8153a88f9846f446ff96d4877ad808280bbd7c43b9bf5feea3dd8d6bd179bc8cf29f949163";
    @RequiresApi(api=28)
    @NonNull
    private static final String V3 = "308203a33082028ba0030201020204698f0c16300d06092a864886f70d01010b0500308180310b300906035504061302434e3110300e060355040813074265696a696e673110300e060355040713074265696a696e67311c301a060355040a13134b75616973686f7520546563686e6f6c6f6779311c301a060355040b13134b75616973686f7520546563686e6f6c6f67793111300f060355040313084b75616973686f753020170d3233303733313038303335305a180f32313233303730373038303335305a308180310b300906035504061302434e3110300e060355040813074265696a696e673110300e060355040713074265696a696e67311c301a060355040a13134b75616973686f7520546563686e6f6c6f6779311c301a060355040b13134b75616973686f7520546563686e6f6c6f67793111300f060355040313084b75616973686f7530820122300d06092a864886f70d01010105000382010f003082010a028201010084959833bc4c1af0269910e2e6292aae4e98842fd8e51b4e6cd7fd17bda30abffdc889d6ee1dd680d4a865cd0dd6456d64ea9ac74756bf59d6aa0b6f344f6208fbce95194be88878ed18a76305abf44d308b26d35b315694a2383c422ca5030cb6fa9795036d4ce33e1185e372860851e52d10c2a3f8f436eb2c706bbfc42301c76e84dc1b4be635cea96f8f4f962bfc79a54472c2878bfbfce11647ae2dfb8f21418457e4fdd1fdba04060e75c40d038b5dd2694706d6601d157442b8e7fd07c2201e9a6dd19ae670973ed26bf54eac34f4c2c2df2a2f5f98a60ead76558297f398dc3b19a7587930506f39ad9bd0b4c65396ec1d14066adefe7dc380a053e10203010001a321301f301d0603551d0e04160414a55cecbc1105cd08678b0348d738c42ba041508f300d06092a864886f70d01010b0500038201010020fcc307cb9e79a288846ee712dfc77b737c9d142a19f7457cf2d4b8ffc901c9d8fcc4b8b7a8519a768def607950554e433122433bc60a68abef699c1569d961404bdfb4bd6bf248d099acb900a555bed725557e5357f9c7f60429456a54662a53e24f2496d8aeb80f459bd2170052774d55db0f188aefe35f747a4fd43214a8af57c9c10a771eca6551474be3a92552a8350015cb72a5d5781b06e7bd27c9364702f67e802a20130333264be911520fb27729a0024d740b9a46ceece35b9a39c86e7fcf4e44802650a46163688c9c078439cdd983456f9e51658b79411f7d500c14197276d858e177aabbca15170eaa9c56b8500edd16416a419d910fab68bd";
    public static final String V3_KWAI_VERSION = "11.7.31";

    KwaiSignature() {
    }

    public boolean isAppVersionSupper(String kwaiVersion) {
        LogUtil.d(TAG, "isAppVersionSupper() called with: kwaiVersion = [" + kwaiVersion + "]");
        try {
            AppVersion expectVersion = Objects.requireNonNull(AppVersion.of(V3_KWAI_VERSION));
            AppVersion currentVersion = Objects.requireNonNull(AppVersion.of(kwaiVersion));
            return currentVersion.compareTo(expectVersion) >= 0;
        }
        catch (Exception e) {
            LogUtil.e(TAG, "isAppVersionSupper: fail", e);
            return false;
        }
    }

    @NonNull
    public String getSignature() {
        return Build.VERSION.SDK_INT >= 28 ? V3 : V2;
    }
}

