/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.kwai.opensdk.sdk.IFinishLoadingListener;
import com.kwai.opensdk.sdk.constants.KwaiOpenSdkCmdEnum;
import com.kwai.opensdk.sdk.model.base.OpenSdkConfig;
import com.kwai.opensdk.sdk.utils.KwaiPlatformUtil;
import com.kwai.opensdk.sdk.utils.LogUtil;
import java.lang.ref.WeakReference;

public class LoadingActivity
extends Activity
implements IFinishLoadingListener {
    public static final String CMD_BUNDLE_KEY = "cmd_bundle_key";
    public static final String KWAI_PLATFORM_KEY = "kwai_platform_key";
    public static final String KWAI_CONFIG_KEY = "kwai_config_key";
    public static final String BUNDLE_KEY_REQUEST_URI = "bundle_key_request_uri";
    private BroadcastReceiver mReceiver = null;

    public void overridePendingTransition(int enterAnim, int exitAnim) {
        super.overridePendingTransition(0, 0);
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getIdentifier((Context)this, "activity_loading", "layout"));
        if (savedInstanceState == null) {
            OpenSdkConfig config;
            String cmdString;
            KwaiOpenSdkCmdEnum cmd;
            String platformString = "kwai_app";
            if (this.getIntent().hasExtra(KWAI_PLATFORM_KEY)) {
                platformString = this.getIntent().getStringExtra(KWAI_PLATFORM_KEY);
            }
            Uri requestUri = this.getIntent().hasExtra(BUNDLE_KEY_REQUEST_URI) ? (Uri)this.getIntent().getParcelableExtra(BUNDLE_KEY_REQUEST_URI) : Uri.parse((String)KwaiPlatformUtil.getPlatformScheme(platformString));
            Intent intent = new Intent("android.intent.action.VIEW", requestUri);
            intent.setPackage(KwaiPlatformUtil.getPlatformPackageName(platformString));
            intent.addCategory("android.intent.category.DEFAULT");
            if (this.getIntent().hasExtra("kwai_bundle_app_info_params")) {
                intent.putExtra("kwai_bundle_app_info_params", this.getIntent().getBundleExtra("kwai_bundle_app_info_params"));
            }
            if (this.getIntent().hasExtra(CMD_BUNDLE_KEY) && null != (cmd = KwaiOpenSdkCmdEnum.getOpenSdkCmd(cmdString = this.getIntent().getStringExtra(CMD_BUNDLE_KEY)))) {
                intent.putExtra(cmd.getBundleKey(), this.getIntent().getBundleExtra(cmd.getBundleKey()));
            }
            if (this.getIntent().hasExtra("kwai_bundle_req_type")) {
                intent.putExtra("kwai_bundle_req_type", this.getIntent().getIntExtra("kwai_bundle_req_type", 0));
            }
            if (this.getIntent().hasExtra("kwai_bundle_config_params")) {
                intent.putExtra("kwai_bundle_config_params", this.getIntent().getBundleExtra("kwai_bundle_config_params"));
            }
            intent.putExtra("req_from_loading_activity", true);
            if (this.getIntent().hasExtra(KWAI_CONFIG_KEY) && (config = (OpenSdkConfig)this.getIntent().getSerializableExtra(KWAI_CONFIG_KEY)) != null && config.isSetNewTaskFlag()) {
                intent.addFlags(0x10000000);
                if (config.isSetClearTaskFlag()) {
                    intent.addFlags(32768);
                }
            }
            LoadingActivity.delayStartAndFinish(this, intent);
            this.registerReceiver();
        }
    }

    private int getIdentifier(@NonNull Context context, @NonNull String name, @NonNull String defType) {
        return context.getResources().getIdentifier(name, defType, context.getPackageName());
    }

    protected void onDestroy() {
        this.removeReceiver();
        super.onDestroy();
    }

    @Override
    public void finishLoading() {
        this.finish();
    }

    public void onBackPressed() {
    }

    static void delayStartAndFinish(Activity activity, final Intent intent) {
        final WeakReference<Activity> ref = new WeakReference<Activity>(activity);
        Handler h = new Handler(Looper.getMainLooper());
        h.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ref.get() != null) {
                    try {
                        ((Activity)ref.get()).startActivity(intent);
                    }
                    catch (ActivityNotFoundException e) {
                        LogUtil.e("KwaiOpenSdk", "not found activity, " + (Object)((Object)e));
                    }
                    catch (SecurityException e) {
                        LogUtil.e("KwaiOpenSdk", "security exception, " + e);
                    }
                }
            }
        }, 500L);
        h.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (ref.get() != null) {
                    ((Activity)ref.get()).finish();
                }
            }
        }, 5000L);
    }

    private void registerReceiver() {
        if (this.mReceiver == null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("com.kwai.opensdk.ACTION_OPEN_SDK_CLOSE_LOADING");
            this.mReceiver = this.createReceiver();
            if (Build.VERSION.SDK_INT >= 33) {
                this.registerReceiver(this.mReceiver, filter, 2);
            } else {
                this.registerReceiver(this.mReceiver, filter);
            }
        }
    }

    private void removeReceiver() {
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
    }

    private BroadcastReceiver createReceiver() {
        return new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && "com.kwai.opensdk.ACTION_OPEN_SDK_CLOSE_LOADING".equals(intent.getAction()) && !LoadingActivity.this.isFinishing()) {
                    LoadingActivity.this.finish();
                }
            }
        };
    }
}

