/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.model.base;

import android.os.Bundle;
import com.kwai.opensdk.sdk.constants.KwaiOpenSdkCmdEnum;
import com.kwai.opensdk.sdk.constants.KwaiPlatform;
import com.kwai.opensdk.sdk.utils.BundleUtil;

public abstract class BaseResp {
    public int errorCode;
    public String errorMsg;
    public String transaction;
    public String sessionId;
    @KwaiPlatform.Platform
    public String platform;

    public abstract KwaiOpenSdkCmdEnum getCommand();

    public void toBundle(Bundle b) {
        b.putString("kwai_bundle_command", this.getCommand().getCmdString());
        b.putString("kwai_bundle_transaction", this.transaction);
        b.putString("kwai_bundle_session_id", this.sessionId);
        b.putInt("kwai_bundle_error_code", this.errorCode);
        b.putString("kwai_bundle_error_msg", this.errorMsg);
        b.putString("kwai_bundle_platform", this.platform);
    }

    public void fromBundle(Bundle b) {
        this.errorCode = BundleUtil.getIntExtra(b, "kwai_bundle_error_code", 1);
        this.errorMsg = BundleUtil.getStringExtra(b, "kwai_bundle_error_msg");
        this.transaction = BundleUtil.getStringExtra(b, "kwai_bundle_transaction");
        this.sessionId = BundleUtil.getStringExtra(b, "kwai_bundle_session_id");
        this.platform = BundleUtil.getStringExtra(b, "kwai_bundle_platform");
    }

    public abstract boolean checkArgs();
}

