/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.model.socialshare;

import android.os.Bundle;
import com.kwai.opensdk.sdk.model.socialshare.KwaiWebpageObject;
import com.kwai.opensdk.sdk.utils.BundleUtil;
import com.kwai.opensdk.sdk.utils.LogUtil;

public final class KwaiMediaMessage {
    public static final int TITLE_LENGTH_LIMIT = 512;
    public static final int DESCRIPTION_LENGTH_LIMIT = 1024;
    public static final int THUMB_LENGTH_LIMIT = 65536;
    public String title;
    public String description;
    public byte[] thumbData;
    public IMediaObject mediaObject;

    public final boolean checkArgs() {
        if (this.thumbData == null || this.thumbData.length > 65536) {
            LogUtil.e("KwaiOpenSdk", "KwaiMediaMessage checkArgs fail, thumbData should not be null or exceed 64K");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            LogUtil.e("KwaiOpenSdk", "KwaiMediaMessage checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            LogUtil.e("KwaiOpenSdk", "KwaiMediaMessage checkArgs fail, description is invalid");
            return false;
        }
        if (this.mediaObject == null) {
            LogUtil.e("KwaiOpenSdk", "KwaiMediaMessage checkArgs fail, mediaObject is null");
            return false;
        }
        return this.mediaObject.checkArgs();
    }

    public final int getType() {
        return this.mediaObject == null ? 0 : this.mediaObject.type();
    }

    public static interface IMediaObject {
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_WEB_PAGE = 1;

        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public int type();

        public boolean checkArgs();
    }

    public static class Builder {
        public static Bundle toBundle(KwaiMediaMessage msg) {
            Bundle bundle = new Bundle();
            bundle.putString("kwai_media_msg_title", msg.title);
            bundle.putString("kwai_media_msg_description", msg.description);
            bundle.putByteArray("kwai_media_msg_thumbdata", msg.thumbData);
            bundle.putInt("kwai_media_msg_type", msg.getType());
            if (msg.mediaObject != null) {
                msg.mediaObject.serialize(bundle);
            }
            return bundle;
        }

        public static KwaiMediaMessage fromBundle(Bundle bundle) {
            KwaiMediaMessage msg = new KwaiMediaMessage();
            msg.title = BundleUtil.getStringExtra(bundle, "kwai_media_msg_title");
            msg.description = BundleUtil.getStringExtra(bundle, "kwai_media_msg_description");
            msg.thumbData = BundleUtil.getByteArrayExtra(bundle, "kwai_media_msg_thumbdata");
            int type = BundleUtil.getIntExtra(bundle, "kwai_media_msg_type", 0);
            switch (type) {
                case 1: {
                    msg.mediaObject = new KwaiWebpageObject();
                }
            }
            if (msg.mediaObject != null) {
                msg.mediaObject.unserialize(bundle);
            }
            return msg;
        }
    }
}

