/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public final class AppPackageUtil {
    public static int getVersionCode(Context context) {
        return AppPackageUtil.getVersionCode(context, context.getPackageName());
    }

    public static int getVersionCode(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return 0;
        }
        int versionCode = 0;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionCode = packageInfo.versionCode;
            return versionCode;
        }
        catch (Exception e) {
            Log.e((String)"PackageUtil", (String)e.getMessage());
            return versionCode;
        }
    }

    public static String getPackageVersion(Context context) {
        return AppPackageUtil.getPackageVersion(context, context.getPackageName());
    }

    public static String getPackageVersion(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        String versionName = null;
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
            versionName = packageInfo.versionName;
            if (TextUtils.isEmpty((CharSequence)versionName)) {
                return null;
            }
        }
        catch (Exception e) {
            Log.e((String)"PackageUtil", (String)e.getMessage());
        }
        return versionName;
    }

    public static Signature[] getPackageSignature(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        if (Build.VERSION.SDK_INT >= 28) {
            return AppPackageUtil.getPackageSignatureP(context, packageName);
        }
        return AppPackageUtil.getPackageSignatureBelowP(context, packageName);
    }

    @Nullable
    public static Signature[] getPackageSignatureBelowP(Context context, String packageName) {
        PackageInfo localPackageInfo;
        PackageManager localPackageManager = context.getPackageManager();
        try {
            localPackageInfo = localPackageManager.getPackageInfo(packageName, 64);
            if (localPackageInfo == null) {
                return null;
            }
        }
        catch (Exception e) {
            Log.e((String)"PackageUtil", (String)e.getMessage());
            return null;
        }
        return localPackageInfo.signatures;
    }

    @RequiresApi(api=28)
    public static Signature[] getPackageSignatureP(@NonNull Context context, @NonNull String packageName) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0x8000000);
            if (packageInfo == null || packageInfo.signingInfo == null) {
                return null;
            }
            return packageInfo.signingInfo.getApkContentsSigners();
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static int getAppSupportAPILevel(Context context, String packageName) {
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return 0;
        }
        try {
            int apiLevel = 0;
            Bundle meta = context.getPackageManager().getApplicationInfo((String)packageName, (int)128).metaData;
            if (meta != null) {
                apiLevel = meta.getInt("openSocialSdkVersionNumber", 0);
            }
            return apiLevel;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Kwai Open Sdk", (String)("get kwai api level failed, " + (Object)((Object)e)));
            return 0;
        }
    }

    public static boolean isAppPackageInstalled(Context context, String packageName) {
        PackageInfo packageInfo;
        if (context == null || TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            packageInfo = null;
        }
        return packageInfo != null;
    }
}

