/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import android.content.Context;
import android.content.pm.Signature;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.kwai.opensdk.sdk.constants.KwaiPlatform;
import com.kwai.opensdk.sdk.model.base.BaseReq;
import com.kwai.opensdk.sdk.utils.AppPackageUtil;
import com.kwai.opensdk.sdk.utils.KwaiSignature;
import java.util.ArrayList;
import java.util.Iterator;

public class KwaiPlatformUtil {
    public static final String KWAI_APP_PACKAGE_NAME = "com.smile.gifmaker";
    public static final String NEBULA_PACKAGE_NAME = "com.kuaishou.nebula";
    public static final String KWAI_APP_SCHEME = "kwai://openapi";
    public static final String NEBULA_SCHEME = "ksnebula://openapi";
    private static final KwaiSignature SIGNATURE = new KwaiSignature();

    public static ArrayList<String> validateAppInstalled(Context context, @KwaiPlatform.Platform String[] platformArray) {
        ArrayList<String> platformList = new ArrayList<String>(2);
        String[] stringArray = platformArray;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String platform;
            switch (platform = stringArray[i]) {
                case "kwai_app": {
                    if (!KwaiPlatformUtil.isAppValidated(context, KWAI_APP_PACKAGE_NAME)) continue block8;
                    platformList.add("kwai_app");
                    continue block8;
                }
                case "nebula_app": {
                    if (!KwaiPlatformUtil.isAppValidated(context, NEBULA_PACKAGE_NAME)) continue block8;
                    platformList.add("nebula_app");
                    continue block8;
                }
            }
        }
        return platformList;
    }

    public static ArrayList<String> matchSupportAPI(@NonNull Context context, @NonNull ArrayList<String> appValidatedList) {
        ArrayList<String> platformList = new ArrayList<String>(2);
        Iterator<String> iterator = appValidatedList.iterator();
        while (iterator.hasNext()) {
            String platform;
            switch (platform = iterator.next()) {
                case "kwai_app": {
                    if (!KwaiPlatformUtil.isAppSupportAPI(context, KWAI_APP_PACKAGE_NAME)) break;
                    platformList.add("kwai_app");
                    break;
                }
                case "nebula_app": {
                    if (!KwaiPlatformUtil.isAppSupportAPI(context, NEBULA_PACKAGE_NAME)) break;
                    platformList.add("nebula_app");
                    break;
                }
            }
        }
        return platformList;
    }

    private static boolean isAppValidated(@NonNull Context context, @NonNull String packageName) {
        return AppPackageUtil.isAppPackageInstalled(context, packageName) && KwaiPlatformUtil.validateSignature(context, packageName, SIGNATURE);
    }

    private static boolean isAppSupportAPI(@NonNull Context context, @NonNull String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 1;
    }

    public static String getPackageNameByReq(@NonNull Context context, @NonNull BaseReq req) {
        ArrayList<String> appValidatedList = KwaiPlatformUtil.validateAppInstalled(context, req.getPlatformArray());
        if (appValidatedList.isEmpty()) {
            return null;
        }
        ArrayList<String> appSupportAPIMatchedList = KwaiPlatformUtil.matchSupportAPI(context, appValidatedList);
        if (appSupportAPIMatchedList.isEmpty()) {
            return null;
        }
        return KwaiPlatformUtil.getPlatformPackageName(appSupportAPIMatchedList.get(0));
    }

    public static boolean isAppSupportUri(@NonNull Context context, String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 2;
    }

    public static boolean isAppSupportEditMultiPicture(@NonNull Context context, String packageName) {
        return AppPackageUtil.getAppSupportAPILevel(context, packageName) > 3;
    }

    public static String getPlatformPackageName(@KwaiPlatform.Platform String platform) {
        if ("kwai_app".equals(platform)) {
            return KWAI_APP_PACKAGE_NAME;
        }
        if ("nebula_app".equals(platform)) {
            return NEBULA_PACKAGE_NAME;
        }
        return null;
    }

    public static String getPlatformScheme(@KwaiPlatform.Platform String platform) {
        if ("kwai_app".equals(platform)) {
            return KWAI_APP_SCHEME;
        }
        if ("nebula_app".equals(platform)) {
            return NEBULA_SCHEME;
        }
        return null;
    }

    public static boolean validateSignature(Context context, String packageName, @NonNull KwaiSignature signature) {
        String appVersion = AppPackageUtil.getPackageVersion(context, packageName);
        if (!signature.isAppVersionSupper(appVersion)) {
            return false;
        }
        String appSignature = signature.getSignature();
        if (context == null || TextUtils.isEmpty((CharSequence)packageName) || TextUtils.isEmpty((CharSequence)appSignature)) {
            return false;
        }
        Signature[] arrayOfSignature = AppPackageUtil.getPackageSignature(context, packageName);
        if (arrayOfSignature == null || arrayOfSignature.length == 0) {
            Log.e((String)"Kwai Open Sdk", (String)"Get signature failed");
            return false;
        }
        for (Signature value : arrayOfSignature) {
            String s = value.toCharsString().toLowerCase();
            if (!appSignature.equals(s)) continue;
            return true;
        }
        Log.e((String)"Kwai Open Sdk", (String)"Signature check failed.");
        return false;
    }
}

