/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import com.kwai.opensdk.sdk.utils.LogUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public final class NetworkUtil {
    public static String get(String url, Map<String, String> params, Map<String, String> headers) {
        return NetworkUtil.request(url, params, null, true, false, headers);
    }

    public static String postData(String url, Map<String, String> params, String content, Map<String, String> headers) {
        return NetworkUtil.request(url, params, content, false, false, headers);
    }

    public static String postFrom(String url, Map<String, String> params, Map<String, String> headers) {
        return NetworkUtil.request(url, null, NetworkUtil.buildFrom(params), false, true, headers);
    }

    public static String postFormJSON(String url, Map<String, String> params, Map<String, String> headers) {
        return NetworkUtil.request(url, null, NetworkUtil.buildJson(params), false, false, headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String request(String url, Map<String, String> params, String body, boolean isGet, boolean isForm, Map<String, String> headers) {
        HttpURLConnection conn = null;
        BufferedReader bufferedReader = null;
        try {
            URL requestUrl = new URL(NetworkUtil.buildUrl(url, params));
            conn = (HttpURLConnection)requestUrl.openConnection();
            conn.setReadTimeout(5000);
            conn.setConnectTimeout(10000);
            if (headers != null && headers.size() > 0) {
                Set<String> keys = headers.keySet();
                for (String key : keys) {
                    conn.setRequestProperty(key, headers.get(key));
                }
            }
            if (!isGet) {
                if (!isForm) {
                    conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                } else {
                    conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                }
                conn.setRequestMethod("POST");
                conn.setDoOutput(true);
                OutputStream out = conn.getOutputStream();
                out.write(body.getBytes());
                out.flush();
                out.close();
            } else {
                conn.setRequestMethod("GET");
            }
            int responseCode = conn.getResponseCode();
            if (responseCode == 200) {
                String line;
                InputStream inputStream = conn.getInputStream();
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                StringBuffer stringBuffer = new StringBuffer();
                while ((line = bufferedReader.readLine()) != null) {
                    stringBuffer.append(line);
                }
                String string = stringBuffer.toString();
                return string;
            }
            Iterator<String> iterator = null;
            return iterator;
        }
        catch (MalformedURLException e) {
            LogUtil.e("NetworkUtil", e.getMessage());
        }
        catch (IOException e) {
            LogUtil.e("NetworkUtil", e.getMessage());
        }
        catch (Exception e) {
            LogUtil.e("NetworkUtil", e.getMessage());
        }
        catch (Throwable e) {
            LogUtil.e("NetworkUtil", e.getMessage());
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    LogUtil.e("NetworkUtil", e.getMessage());
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    private static String buildUrl(String url, Map<String, String> params) {
        if (params == null) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url);
        if (url.contains("?")) {
            urlBuilder.append("&");
        } else {
            urlBuilder.append("?");
        }
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null) continue;
            urlBuilder.append(key);
            urlBuilder.append("=");
            try {
                urlBuilder.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.e("NetworkUtil", e.getMessage());
            }
            urlBuilder.append("&");
        }
        urlBuilder.deleteCharAt(urlBuilder.length() - 1);
        return urlBuilder.toString();
    }

    private static String buildFrom(Map<String, String> params) {
        if (params == null) {
            return null;
        }
        StringBuilder formBuilder = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value == null) continue;
            formBuilder.append(key);
            formBuilder.append("=");
            try {
                formBuilder.append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                LogUtil.e("NetworkUtil", e.getMessage());
            }
            formBuilder.append("&");
        }
        formBuilder.deleteCharAt(formBuilder.length() - 1);
        return formBuilder.toString();
    }

    private static String buildJson(Map<String, String> params) {
        if (params == null || params.size() == 0) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        try {
            for (String key : params.keySet()) {
                String value = params.get(key);
                if (value == null) continue;
                jsonObject.put(key, (Object)params.get(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonObject.toString();
    }
}

