/*
 * Decompiled with CFR 0.152.
 */
package com.kwai.opensdk.sdk.utils;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MarketUtil {
    private static final String PACKAGE_MI_MARKET = "com.xiaomi.market";
    private static final String PACKAGE_MEIZU_MARKET = "com.meizu.mstore";
    private static final String PACKAGE_VIVO_MARKET = "com.bbk.appstore";
    private static final String PACKAGE_OPPO_MARKET = "com.oppo.market";
    private static final String PACKAGE_HUAWEI_MARKET = "com.huawei.appmarket";
    private static final String PACKAGE_ZTE_MARKET = "zte.com.market";
    private static final String PACKAGE_360_MARKET = "com.qihoo.appstore";
    private static final String PACKAGE_COOL_MARKET = "com.coolapk.market";
    private static final String PACKAGE_TENCENT_MARKET = "com.tencent.android.qqdownloader";
    private static final String PACKAGE_ALI_MARKET = "com.pp.assistant";
    private static final String PACKAGE_WANDOUJIA_MARKET = "com.wandoujia.phoenix2";
    private static final String PACKAGE_UCWEB_MARKET = "com.UCMobile";
    public static Map<String, String> MARKET_DEFAULT = new HashMap<String, String>();

    public static boolean gotoMarket(Context context, String packageName) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)("market://details?id=" + packageName)));
        intent.addFlags(0x10000000);
        try {
            if (MarketUtil.isIntentAvailable(context, intent)) {
                context.startActivity(intent);
            } else {
                Intent chooser = Intent.createChooser((Intent)intent, (CharSequence)"\u8bf7\u9009\u62e9\u4e0b\u8f7d\u65b9\u5f0f");
                context.startActivity(chooser);
            }
            return true;
        }
        catch (Exception e) {
            Intent launch;
            e.printStackTrace();
            String keys = MarketUtil.choseMarket(context);
            if (keys != null && (launch = MarketUtil.getLaunchIntent(context, keys)) != null) {
                launch.addFlags(0x10000000);
                try {
                    context.startActivity(launch);
                    return true;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            return false;
        }
    }

    private static String choseMarket(Context context) {
        for (Map.Entry<String, String> entry : MARKET_DEFAULT.entrySet()) {
            if (!MarketUtil.isPackageExist(context, entry.getValue())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static boolean isPackageExist(Context context, String packageName) {
        Intent intent;
        PackageManager manager = context.getPackageManager();
        List infos = manager.queryIntentActivities(intent = new Intent().setPackage(packageName), 32);
        return infos != null && infos.size() >= 1;
    }

    private static Intent getLaunchIntent(Context context, String packageName) {
        ResolveInfo resolveinfo;
        Intent intent = context.getPackageManager().getLaunchIntentForPackage(packageName);
        if (intent != null) {
            return intent;
        }
        intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        intent.setPackage(packageName);
        List list = context.getPackageManager().queryIntentActivities(intent, 0);
        if (list != null && list.size() > 0 && (resolveinfo = (ResolveInfo)list.iterator().next()) != null) {
            String className = resolveinfo.activityInfo.name;
            ComponentName cn = new ComponentName(packageName, className);
            intent.setComponent(cn);
            return intent;
        }
        return intent;
    }

    @SuppressLint(value={"WrongConstant"})
    private static boolean isIntentAvailable(Context context, Intent intent) {
        PackageManager packageManager = context.getPackageManager();
        List list = packageManager.queryIntentActivities(intent, 1);
        return list.size() > 0;
    }

    static {
        MARKET_DEFAULT.put("xiaomi", PACKAGE_MI_MARKET);
        MARKET_DEFAULT.put("meizu", PACKAGE_MEIZU_MARKET);
        MARKET_DEFAULT.put("vivo", PACKAGE_VIVO_MARKET);
        MARKET_DEFAULT.put("oppo", PACKAGE_OPPO_MARKET);
        MARKET_DEFAULT.put("huawei", PACKAGE_HUAWEI_MARKET);
        MARKET_DEFAULT.put("360", PACKAGE_360_MARKET);
        MARKET_DEFAULT.put("ysdk", PACKAGE_TENCENT_MARKET);
        MARKET_DEFAULT.put("uc", PACKAGE_UCWEB_MARKET);
        MARKET_DEFAULT.put("zte", PACKAGE_ZTE_MARKET);
        MARKET_DEFAULT.put("pp", PACKAGE_ALI_MARKET);
        MARKET_DEFAULT.put("wdj", PACKAGE_WANDOUJIA_MARKET);
        MARKET_DEFAULT.put("cool", PACKAGE_COOL_MARKET);
    }
}

