/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.BitReader;
import com.idrsolutions.pdf.color.shading.CoonsPatch;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.jpedal.color.GenericColorSpace;

public class ShadingDatastreamReader {
    private final BitReader reader;
    private final int bitsPerCoord;
    private final int bitsPerComp;
    private final int compCount;
    private final int bitsPerFlag;
    private final int type;
    private boolean processed;
    private final GenericColorSpace shadingColorSpace;
    private final ArrayList patches = new ArrayList();

    public ShadingDatastreamReader(byte[] data, int bitsPerCoord, int bitsPerComp, int compCount, int bitsPerFlag, GenericColorSpace shadingColorSpace, int type) {
        this.bitsPerCoord = bitsPerCoord;
        this.bitsPerComp = bitsPerComp;
        this.compCount = compCount;
        this.bitsPerFlag = bitsPerFlag;
        this.shadingColorSpace = shadingColorSpace;
        this.type = type;
        boolean hasSmallBits = bitsPerFlag < 8 || bitsPerComp < 8 || bitsPerCoord < 8;
        this.reader = new BitReader(data, hasSmallBits);
    }

    public ArrayList getPatches() {
        if (!this.processed) {
            this.process();
            this.processed = true;
        }
        return this.patches;
    }

    private void addShapePoints8(CoonsPatch patch) {
        for (int i = 0; i < 8; ++i) {
            patch.addPoint(this.reader.getFloat(this.bitsPerCoord), this.reader.getFloat(this.bitsPerCoord));
        }
    }

    private void addShapePoints12(CoonsPatch patch) {
        for (int i = 0; i < 12; ++i) {
            patch.addPoint(this.reader.getFloat(this.bitsPerCoord), this.reader.getFloat(this.bitsPerCoord));
        }
    }

    private void addShapePoints16(CoonsPatch patch) {
        int i;
        for (i = 0; i < 12; ++i) {
            patch.addPoint(this.reader.getFloat(this.bitsPerCoord), this.reader.getFloat(this.bitsPerCoord));
        }
        for (i = 0; i < 4; ++i) {
            this.reader.getFloat(this.bitsPerCoord);
            this.reader.getFloat(this.bitsPerCoord);
        }
    }

    private void process() {
        while (this.reader.getPointer() < this.reader.getTotalBitLen()) {
            int flag = this.reader.getPositive(this.bitsPerFlag);
            Point2D[] a4 = new Point2D[8];
            switch (flag) {
                case 0: {
                    CoonsPatch patch;
                    if (this.type == 6) {
                        patch = new CoonsPatch(this.compCount, this.shadingColorSpace);
                        this.addShapePoints12(patch);
                    } else if (this.type == 7) {
                        patch = new CoonsPatch(this.compCount, this.shadingColorSpace);
                        this.addShapePoints16(patch);
                    } else {
                        return;
                    }
                    for (int i = 0; i < 4; ++i) {
                        for (int c = 0; c < this.compCount; ++c) {
                            patch.addColorValue(this.reader.getFloat(this.bitsPerComp));
                        }
                    }
                    this.patches.add(patch);
                    break;
                }
                case 1: {
                    int c;
                    int i;
                    if (this.type == 7) {
                        return;
                    }
                    CoonsPatch patch1 = new CoonsPatch(this.compCount, this.shadingColorSpace);
                    CoonsPatch prev1 = (CoonsPatch)this.patches.get(this.patches.size() - 1);
                    double[] prev1Arr = prev1.getPoints();
                    float[][] prev1Color = prev1.getColors();
                    a4[0] = new Point2D.Double(prev1Arr[6], prev1Arr[7]);
                    a4[1] = new Point2D.Double(prev1Arr[8], prev1Arr[9]);
                    a4[2] = new Point2D.Double(prev1Arr[10], prev1Arr[11]);
                    a4[3] = new Point2D.Double(prev1Arr[12], prev1Arr[13]);
                    for (int i2 = 0; i2 < 4; ++i2) {
                        patch1.addPoint(a4[i2].getX(), a4[i2].getY());
                    }
                    this.addShapePoints8(patch1);
                    float[][] temp1 = new float[2][this.compCount];
                    temp1[0] = prev1Color[1];
                    temp1[1] = prev1Color[2];
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch1.addColorValue(temp1[i][c]);
                        }
                    }
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch1.addColorValue(this.reader.getFloat(this.bitsPerComp));
                        }
                    }
                    this.patches.add(patch1);
                    break;
                }
                case 2: {
                    int c;
                    int i;
                    if (this.type == 7) {
                        return;
                    }
                    CoonsPatch patch2 = new CoonsPatch(this.compCount, this.shadingColorSpace);
                    CoonsPatch prev2 = (CoonsPatch)this.patches.get(this.patches.size() - 1);
                    double[] prev2Arr = prev2.getPoints();
                    float[][] prev2Color = prev2.getColors();
                    a4[0] = new Point2D.Double(prev2Arr[12], prev2Arr[13]);
                    a4[1] = new Point2D.Double(prev2Arr[14], prev2Arr[15]);
                    a4[2] = new Point2D.Double(prev2Arr[16], prev2Arr[17]);
                    a4[3] = new Point2D.Double(prev2Arr[18], prev2Arr[19]);
                    for (i = 0; i < 4; ++i) {
                        patch2.addPoint(a4[i].getX(), a4[i].getY());
                    }
                    this.addShapePoints8(patch2);
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch2.addColorValue(prev2Color[2 + i][c]);
                        }
                    }
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch2.addColorValue(this.reader.getFloat(this.bitsPerComp));
                        }
                    }
                    this.patches.add(patch2);
                    break;
                }
                case 3: {
                    int c;
                    int i;
                    if (this.type == 7) {
                        return;
                    }
                    CoonsPatch patch3 = new CoonsPatch(this.compCount, this.shadingColorSpace);
                    CoonsPatch prev3 = (CoonsPatch)this.patches.get(this.patches.size() - 1);
                    double[] prev3Arr = prev3.getPoints();
                    float[][] prev3Color = prev3.getColors();
                    a4[0] = new Point2D.Double(prev3Arr[18], prev3Arr[19]);
                    a4[1] = new Point2D.Double(prev3Arr[20], prev3Arr[21]);
                    a4[2] = new Point2D.Double(prev3Arr[22], prev3Arr[23]);
                    a4[3] = new Point2D.Double(prev3Arr[0], prev3Arr[1]);
                    for (int i3 = 0; i3 < 4; ++i3) {
                        patch3.addPoint(a4[i3].getX(), a4[i3].getY());
                    }
                    this.addShapePoints8(patch3);
                    float[][] temp = new float[2][this.compCount];
                    temp[0] = prev3Color[3];
                    temp[1] = prev3Color[0];
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch3.addColorValue(temp[i][c]);
                        }
                    }
                    for (i = 0; i < 2; ++i) {
                        for (c = 0; c < this.compCount; ++c) {
                            patch3.addColorValue(this.reader.getFloat(this.bitsPerComp));
                        }
                    }
                    this.patches.add(patch3);
                }
            }
        }
    }
}

