/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui;

import java.awt.datatransfer.Transferable;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import org.jpedal.examples.viewer.Commands;
import org.jpedal.examples.viewer.Values;
import org.jpedal.examples.viewer.gui.BaseTransferHandler;
import org.jpedal.examples.viewer.gui.SwingGUI;
import org.jpedal.examples.viewer.gui.generic.GUIThumbnailPanel;
import org.jpedal.utils.Messages;
import org.jpedal.utils.SwingWorker;

public class MultiViewTransferHandler
extends BaseTransferHandler {
    private static final long serialVersionUID = 271129748262568046L;
    private int fileCount = 0;

    public MultiViewTransferHandler(Values commonValues, GUIThumbnailPanel thumbnails, SwingGUI currentGUI, Commands currentCommands) {
        super(commonValues, thumbnails, currentGUI, currentCommands);
    }

    @Override
    public boolean importData(JComponent src, Transferable transferable) {
        try {
            Object dragImport = this.getImport(transferable);
            if (dragImport instanceof String) {
                String url = (String)dragImport;
                System.out.println(url);
                String testURL = url.toLowerCase();
                if (testURL.startsWith("http:/")) {
                    this.currentCommands.openTransferedFile(testURL);
                    return true;
                }
                if (testURL.startsWith("file:/")) {
                    String[] urls = url.split("file:/");
                    LinkedList<File> files = new LinkedList<File>();
                    for (String file : urls) {
                        if (file.length() <= 0) continue;
                        File file2 = new File(new URL("file:/" + file).getFile());
                        System.out.println(file2);
                        files.add(file2);
                    }
                    return this.openFiles(files);
                }
            } else if (dragImport instanceof List) {
                List files = (List)dragImport;
                return this.openFiles(files);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean openFiles(List<File> files) {
        this.fileCount = 0;
        List<String> flattenedFiles = this.getFlattenedFiles(files, new ArrayList<String>());
        if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
            this.currentGUI.showMessageDialog((Object)("You have choosen to import more files than your current set maximum (" + this.commonValues.getMaxMiltiViewers() + ").  Only the first " + this.commonValues.getMaxMiltiViewers() + " files will be imported.\nYou can change this value in View | Preferences"), "Maximum number of files reached", 1);
        }
        List[] filterdFiles = MultiViewTransferHandler.filterFiles(flattenedFiles);
        final List allowedFiles = filterdFiles[0];
        List disAllowedFiles = filterdFiles[1];
        int noOfDisAllowedFiles = disAllowedFiles.size();
        int noOfAllowedFiles = allowedFiles.size();
        if (noOfDisAllowedFiles > 0) {
            String unOpenableFiles = "";
            for (Object disAllowedFile : disAllowedFiles) {
                String file = (String)disAllowedFile;
                String fileName = new File(file).getName();
                unOpenableFiles = unOpenableFiles + fileName + '\n';
            }
            int result = this.currentGUI.showConfirmDialog("You have selected " + flattenedFiles.size() + " files to open.  The following file(s) cannot be opened\nas they are not valid PDFs or images.\n" + unOpenableFiles + "\nWould you like to open the remaining " + noOfAllowedFiles + " files?", "File Import", 0, 3);
            if (result == 1) {
                return false;
            }
        }
        SwingWorker worker = new SwingWorker(){

            @Override
            public Object construct() {
                for (Object allowedFile : allowedFiles) {
                    String file = (String)allowedFile;
                    try {
                        MultiViewTransferHandler.this.currentCommands.openTransferedFile(file);
                    }
                    catch (Exception e) {
                        int result;
                        if (allowedFiles.size() == 1) {
                            MultiViewTransferHandler.this.currentGUI.showMessageDialog((Object)Messages.getMessage("PdfViewerOpenerror"), MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0);
                            result = 1;
                        } else {
                            result = MultiViewTransferHandler.this.currentGUI.showConfirmDialog(Messages.getMessage("PdfViewerOpenerror") + ". Continue opening remaining files?", MultiViewTransferHandler.this.commonValues.getSelectedFile(), 0, 3);
                        }
                        MultiViewTransferHandler.this.currentGUI.closeMultiViewerWindow(MultiViewTransferHandler.this.commonValues.getSelectedFile());
                        if (result != 1) continue;
                        return null;
                    }
                }
                return null;
            }
        };
        worker.start();
        return true;
    }

    private static List[] filterFiles(List<String> flattenedFiles) {
        LinkedList<String> allowedFiles = new LinkedList<String>();
        LinkedList<String> disAllowedFiles = new LinkedList<String>();
        for (String flattenedFile : flattenedFiles) {
            boolean isValid;
            String file = flattenedFile;
            String testFile = file.toLowerCase();
            boolean bl = isValid = testFile.endsWith(".pdf") || testFile.endsWith(".fdf") || testFile.endsWith(".tif") || testFile.endsWith(".tiff") || testFile.endsWith(".png") || testFile.endsWith(".jpg") || testFile.endsWith(".jpeg");
            if (isValid) {
                allowedFiles.add(file);
                continue;
            }
            disAllowedFiles.add(file);
        }
        return new List[]{allowedFiles, disAllowedFiles};
    }

    private List<String> getFlattenedFiles(List<File> files, List<String> flattenedFiles) {
        for (File file1 : files) {
            if (this.fileCount == this.commonValues.getMaxMiltiViewers()) {
                return flattenedFiles;
            }
            File file = file1;
            if (file.isDirectory()) {
                this.getFlattenedFiles(Arrays.asList(file.listFiles()), flattenedFiles);
                continue;
            }
            flattenedFiles.add(file.getAbsolutePath());
            ++this.fileCount;
        }
        return flattenedFiles;
    }
}

