/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples.viewer.gui.swing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jpedal.examples.viewer.gui.generic.GUIOutline;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwingOutline
extends JScrollPane
implements GUIOutline {
    private static final long serialVersionUID = 7137966529258622413L;
    private Map pageLookupTableViaTitle = new HashMap();
    private Map nodeToRef = new HashMap();
    private Map closedNodes = new HashMap();
    private DefaultMutableTreeNode top = new DefaultMutableTreeNode("Root");
    private JTree tree;
    private boolean hasDuplicateTitles;

    public SwingOutline() {
        this.getViewport().add(new JLabel("No outline"));
    }

    @Override
    public void reset(Node rootNode) {
        this.top.removeAllChildren();
        if (this.tree != null) {
            this.getViewport().remove(this.tree);
        }
        this.pageLookupTableViaTitle.clear();
        this.nodeToRef.clear();
        this.closedNodes.clear();
        this.hasDuplicateTitles = false;
        if (rootNode != null) {
            this.hasDuplicateTitles = false;
            this.readChildNodes(rootNode, this.top, 0);
        }
        this.tree = new JTree(this.top);
        this.tree.setName("Tree");
        if (rootNode != null) {
            this.expandAll();
        }
        this.tree.setRootVisible(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.getViewport().add(this.tree);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
    }

    private void expandAll() {
        for (int row = 1; row < 4; ++row) {
            if (!this.closedNodes.containsKey(row)) {
                this.tree.expandRow(row);
                continue;
            }
            this.tree.collapseRow(row);
        }
    }

    @Override
    public int readChildNodes(Node rootNode, DefaultMutableTreeNode topNode, int nodeIndex) {
        if (topNode == null) {
            topNode = this.top;
        }
        NodeList children = rootNode.getChildNodes();
        int childCount = children.getLength();
        for (int i = 0; i < childCount; ++i) {
            Node child = children.item(i);
            Element currentElement = (Element)child;
            String title = currentElement.getAttribute("title");
            String page = currentElement.getAttribute("page");
            String isClosed = currentElement.getAttribute("isClosed");
            String ref = currentElement.getAttribute("objectRef");
            if (this.pageLookupTableViaTitle.containsKey(title)) {
                this.hasDuplicateTitles = true;
            } else {
                this.pageLookupTableViaTitle.put(title, page);
            }
            if (isClosed.equals("true")) {
                this.closedNodes.put(nodeIndex, "x");
            }
            this.nodeToRef.put(nodeIndex, ref);
            ++nodeIndex;
            DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(title);
            topNode.add(childNode);
            if (!child.hasChildNodes()) continue;
            nodeIndex = this.readChildNodes(child, childNode, nodeIndex);
        }
        return nodeIndex;
    }

    @Override
    public String getPage(String title) {
        if (this.hasDuplicateTitles) {
            return null;
        }
        return (String)this.pageLookupTableViaTitle.get(title);
    }

    @Override
    public String convertNodeIDToRef(int nodeNumber) {
        return (String)this.nodeToRef.get(nodeNumber);
    }

    @Override
    public void selectBookmark() {
    }

    @Override
    public Object getTree() {
        return this.tree;
    }

    @Override
    public DefaultMutableTreeNode getLastSelectedPathComponent() {
        return (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
    }
}

