/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.utils.LogWriter;

public class Type1
extends PdfFont {
    private static final long serialVersionUID = 3770968246210164415L;
    protected boolean isCID = false;
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    public static final String[] T1CcharCodes1Byte = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closePathT1", "callsubr", "return", "escape", "hsbwT1", "endchar", "-Reserved-", "blend", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "intint", "callgsubr", "vhcurveto", "hvcurveto"};
    public static final String[] T1C = new String[]{"dotSection", "vstem3", "hstem3", "and", "or", "not", "seacT1", "swbT1", "store", "abs", "add", "sub", "div", "load", "neg", "eq", "callothersubT1", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpointT1", "hflex", "flex", "hflex1", "flex1"};
    boolean trackIndices = false;

    public Type1(PdfObjectReader current_pdf_file, String substiuteFont) {
        this.init(current_pdf_file);
        this.substituteFont = substiuteFont;
    }

    public Type1() {
    }

    protected final void readType1FontFile(byte[] content) throws Exception {
        block13: {
            String line;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
            }
            BufferedReader br = new BufferedReader(new StringReader(new String(content)));
            while ((line = br.readLine()) != null) {
                int endP;
                if (line.startsWith("/Encoding 256 array")) {
                    this.readDiffEncoding(br);
                    continue;
                }
                if (line.startsWith("/lenIV")) {
                    StringTokenizer vals = new StringTokenizer(line);
                    vals.nextToken();
                    this.skipBytes = Integer.parseInt(vals.nextToken());
                    continue;
                }
                if (!line.contains("/FontMatrix")) continue;
                String values = "";
                int startP = line.indexOf(91);
                if (startP != -1) {
                    endP = line.indexOf(93);
                    values = line.substring(startP + 1, endP);
                } else {
                    startP = line.indexOf(123);
                    if (startP != -1) {
                        endP = line.indexOf(125);
                        values = line.substring(startP + 1, endP);
                    }
                }
                StringTokenizer matrixValues = new StringTokenizer(values);
                for (int i = 0; i < 6; ++i) {
                    this.FontMatrix[i] = Double.parseDouble(matrixValues.nextToken());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception " + e + " closing stream");
                }
            }
        }
        int glyphCount = 0;
        if (this.renderPage) {
            glyphCount = this.readEncodedContent(content);
        }
        this.glyphs.setGlyphCount(glyphCount);
        if (!this.renderPage || glyphCount > 0) {
            this.isFontEmbedded = true;
        }
        this.glyphs.setFontEmbedded(true);
    }

    private void readDiffEncoding(BufferedReader br) throws Exception {
        String line;
        while ((line = br.readLine()) != null && !(line = line.trim()).startsWith("readonly")) {
            int code;
            StringTokenizer info;
            if (!line.startsWith("dup") || !line.contains("/") || (info = new StringTokenizer(line, " /")).countTokens() < 3) continue;
            info.nextToken();
            String rawVal = info.nextToken();
            int ptr = rawVal.indexOf(35);
            if (ptr == -1) {
                code = Integer.parseInt(rawVal);
            } else {
                String base = rawVal.substring(0, ptr);
                String val = rawVal.substring(ptr + 1, rawVal.length());
                code = Integer.parseInt(val, Integer.parseInt(base));
            }
            String name = info.nextToken();
            this.putChar(code, name);
            char c = name.charAt(0);
            if (c != 'B' && c != 'C' && c != 'c' && c != 'G') continue;
            int i = 1;
            int l = name.length();
            while (!this.isHex && i < l) {
                this.isHex = Character.isLetter(name.charAt(i++));
            }
        }
    }

    protected final void putChar(int charInt, String mappedChar) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[charInt] = mappedChar;
        if (!this.hasEncoding && !this.isCID) {
            if (StandardFonts.getUnicodeName(mappedChar) != null) {
                this.putMappedChar(charInt, mappedChar);
            } else {
                this.nonStandardMappings.put(mappedChar, charInt);
            }
        }
    }

    private int readEncodedContent(byte[] cont) throws Exception {
        String line;
        int i;
        int glyphCount = 0;
        String rd = "rd";
        String nd = "nd";
        int size = cont.length;
        int start = -1;
        int end = -1;
        for (i = 4; i < size; ++i) {
            if (cont[i - 3] != 101 || cont[i - 2] != 120 || cont[i - 1] != 101 || cont[i] != 99) continue;
            start = i + 1;
            while (cont[start] == 10 || cont[start] == 13) {
                ++start;
            }
            i = size;
        }
        if (start != -1) {
            for (i = start; i < size - 10; ++i) {
                if (cont[i] != 99 || cont[i + 1] != 108 || cont[i + 2] != 101 || cont[i + 3] != 97 || cont[i + 4] != 114 || cont[i + 5] != 116 || cont[i + 6] != 111 || cont[i + 7] != 109 || cont[i + 8] != 97 || cont[i + 9] != 114 || cont[i + 10] != 107) continue;
                end = i - 1;
                while (cont[end] == 10 || cont[end] == 13) {
                    --end;
                }
                i = size;
            }
        }
        if (end == -1) {
            end = size;
        }
        int r = 55665;
        int n = 4;
        boolean isAscii = true;
        for (i = start; i < start + n * 2; ++i) {
            char c = (char)cont[i];
            if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
            isAscii = false;
            break;
        }
        if (start != -1) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(end - start);
            if (this.isFontSubstituted && !isAscii) {
                start = start + 2 + this.skipBytes;
            }
            for (i = start; i < end; ++i) {
                int cipher;
                if (!isAscii) {
                    cipher = cont[i] & 0xFF;
                } else {
                    int chars = 0;
                    StringBuilder tmp = new StringBuilder();
                    while (chars < 2) {
                        cipher = cont[i] & 0xFF;
                        ++i;
                        if (cipher == 10 || cipher == 13 || cipher == 9 || cipher == 32) continue;
                        tmp.append((char)cipher);
                        ++chars;
                    }
                    --i;
                    cipher = Integer.parseInt(tmp.toString(), 16);
                }
                int plain = cipher ^ r >> 8;
                r = (cipher + r) * 52845 + 22719 & 0xFFFF;
                if (i <= start + n) continue;
                bos.write(plain);
            }
            bos.close();
            cont = bos.toByteArray();
        }
        BufferedReader br = new BufferedReader(new StringReader(new String(cont)));
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("/lenIV")) continue;
            StringTokenizer vals = new StringTokenizer(line);
            vals.nextToken();
            this.skipBytes = Integer.parseInt(vals.nextToken());
        }
        br.close();
        int l = cont.length;
        int subStart = -1;
        start = -1;
        for (int p = 0; p < l && p != l; ++p) {
            if (p + 11 < l && cont[p] == 47 && cont[p + 1] == 67 && cont[p + 2] == 104 && cont[p + 3] == 97 && cont[p + 4] == 114 && cont[p + 5] == 83 && cont[p + 6] == 116 && cont[p + 7] == 114 && cont[p + 8] == 105 && cont[p + 9] == 110 && cont[p + 10] == 103 && cont[p + 11] == 115) {
                start = p + 11;
            } else if (p + 5 < l && cont[p] == 47 && cont[p + 1] == 83 && cont[p + 2] == 117 && cont[p + 3] == 98 && cont[p + 4] == 114 && cont[p + 5] == 115) {
                subStart = p + 6;
            }
            if (subStart > -1 && start > -1) break;
        }
        if (start == -1) {
            this.isFontSubstituted = false;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No glyph data found");
            }
        } else {
            glyphCount = this.extractFontData(this.skipBytes, cont, start, rd, l, nd);
        }
        if (subStart > -1) {
            this.extractSubroutineData(this.skipBytes, cont, subStart, start, rd, l, nd);
        }
        return glyphCount;
    }

    private void extractSubroutineData(int skipBytes, byte[] cont, int start, int charStart, String rd, int l, String nd) throws IOException {
        char c;
        while (cont[start] == 32 || cont[start] == 10 || cont[start] == 13) {
            ++start;
        }
        StringBuilder tmp = new StringBuilder();
        while ((c = (char)cont[start]) != ' ') {
            tmp.append(c);
            ++start;
        }
        int count = Integer.parseInt(tmp.toString());
        for (int i = 0; i < count; ++i) {
            char c2;
            while (start < l && !((cont[start - 2] == 100 && cont[start - 1] == 117 && cont[start] == 112) | start == charStart)) {
                ++start;
            }
            if (start == charStart) {
                i = count;
                continue;
            }
            while (cont[start + 1] == 32) {
                ++start;
            }
            StringBuilder glyph = new StringBuilder("subrs");
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            tmp = new StringBuilder();
            while ((c2 = (char)cont[++start]) != ' ') {
                tmp.append(c2);
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            start = start + rd.length() + 1;
            byte[] stream = Type1.getStream(skipBytes, start, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, i);
            start = start + byteCount + nd.length();
        }
    }

    private int extractFontData(int skipBytes, byte[] cont, int start, String rd, int l, String nd) throws IOException {
        int total = cont.length;
        int glyphCount = 0;
        while (start < total && cont[start] != 47) {
            ++start;
        }
        int end = start;
        while (start < l) {
            if (cont[end] == 47) {
                end += 2;
                while (end < total && (cont[end - 1] != 124 || cont[end] != 45 && cont[end] != 48 || cont[end + 1] != 10 && cont[end + 1] != 13) && (cont[end - 1] != 78 || cont[end] != 68)) {
                    ++end;
                }
            }
            if (total - end < 3 || cont[end - 1] != 47 && cont[end] == 101 && cont[end + 1] == 110 && cont[end + 2] == 100) break;
            ++end;
        }
        while (start <= end) {
            char c;
            char c2;
            StringBuilder glyph = new StringBuilder(20);
            while ((c2 = (char)cont[++start]) != ' ') {
                glyph.append(c2);
            }
            if (this.trackIndices) {
                this.glyphs.setIndexForCharString(glyphCount, glyph.toString());
            }
            ++start;
            StringBuilder tmp = new StringBuilder();
            while ((c = (char)cont[start]) != ' ') {
                tmp.append(c);
                ++start;
            }
            int byteCount = Integer.parseInt(tmp.toString());
            while (cont[start] == 32) {
                ++start;
            }
            start = start + rd.length() + 1;
            byte[] stream = Type1.getStream(skipBytes, start, byteCount, cont);
            this.glyphs.setCharString(glyph.toString(), stream, glyphCount);
            ++glyphCount;
            for (start = start + byteCount + nd.length(); start <= end && cont[start] != 47; ++start) {
            }
        }
        return glyphCount;
    }

    private static final byte[] getStream(int skipBytes, int start, int byteCount, byte[] cont) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        int r = 4330;
        for (int i = 0; i < byteCount; ++i) {
            int cipher = cont[start + i] & 0xFF;
            int plain = cipher ^ r >> 8;
            r = (cipher + r) * 52845 + 22719 & 0xFFFF;
            if (i < skipBytes) continue;
            bos.write(plain);
        }
        bos.close();
        return bos.toByteArray();
    }
}

