/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import org.jpedal.color.PdfPaint;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.gui.ShowGUIMessage;
import org.jpedal.io.PathSerializer;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Path;
import org.jpedal.utils.repositories.Vector_Short;

public class TTGlyph
implements PdfGlyph,
Serializable {
    private static final long serialVersionUID = -4296884514669454220L;
    public static boolean useHinting = false;
    public static boolean redecodePage = false;
    private static HashSet testedFonts;
    private boolean containsBrokenGlyfData;
    private boolean ttHintingRequired;
    private short minX;
    private short minY;
    private short maxX;
    private short maxY;
    int BPoint1;
    int BPoint2;
    int BP1x;
    int BP2x;
    int BP1y;
    int BP2y;
    private short compMinX;
    private short compMinY;
    private short compMaxX;
    private short compMaxY;
    private int[] scaledX;
    private int[] scaledY;
    private short leftSideBearing;
    private Vector_Int xtranslateValues;
    private Vector_Int ytranslateValues;
    private Vector_Double xscaleValues;
    private Vector_Double yscaleValues;
    private Vector_Double scale01Values;
    private Vector_Double scale10Values;
    private int xtranslate;
    private int ytranslate;
    private double xscale;
    private double yscale;
    private double scale01;
    private double scale10;
    private int[] instructions;
    private int currentInstructionDepth;
    private Vector_Object glyfX;
    private Vector_Object glyfY;
    private Vector_Object curves;
    private Vector_Object contours;
    private Vector_Int endPtIndices;
    private int contourCount;
    private float unitsPerEm;
    public boolean debug;
    private transient Vector_Path paths;
    private int compCount;
    private boolean isComposite;
    String glyfName;
    private double pixelSize;
    int existingXTranslate;
    int existingYTranslate;
    int depth;
    Area glyphShape;
    BufferedImage img;
    int id;

    public void setPaths(Vector_Path vp) {
        this.paths = vp;
    }

    public void writePathsToStream(ObjectOutput os) throws IOException {
        if (this.paths != null) {
            int i;
            GeneralPath[] generalPaths = this.paths.get();
            int count = 0;
            for (i = 0; i < generalPaths.length; ++i) {
                if (generalPaths[i] != null) continue;
                count = i;
                break;
            }
            os.writeObject(count);
            for (i = 0; i < count; ++i) {
                PathIterator pathIterator = generalPaths[i].getPathIterator(new AffineTransform());
                PathSerializer.serializePath(os, pathIterator);
            }
        }
    }

    public TTGlyph() {
        this.containsBrokenGlyfData = false;
        this.ttHintingRequired = false;
        this.BP1x = -1;
        this.BP2x = -1;
        this.BP1y = -1;
        this.BP2y = -1;
        this.xtranslateValues = new Vector_Int(5);
        this.ytranslateValues = new Vector_Int(5);
        this.xscaleValues = new Vector_Double(5);
        this.yscaleValues = new Vector_Double(5);
        this.scale01Values = new Vector_Double(5);
        this.scale10Values = new Vector_Double(5);
        this.xscale = 1.0;
        this.yscale = 1.0;
        this.scale01 = 0.0;
        this.scale10 = 0.0;
        this.currentInstructionDepth = Integer.MAX_VALUE;
        this.glyfX = new Vector_Object(5);
        this.glyfY = new Vector_Object(5);
        this.curves = new Vector_Object(5);
        this.contours = new Vector_Object(5);
        this.endPtIndices = new Vector_Int(5);
        this.contourCount = 0;
        this.unitsPerEm = 64.0f;
        this.debug = false;
        this.paths = new Vector_Path(10);
        this.compCount = 1;
        this.isComposite = false;
        this.glyfName = "";
        this.existingXTranslate = 0;
        this.existingYTranslate = 0;
        this.depth = 0;
        this.glyphShape = null;
        this.img = null;
        this.id = 0;
    }

    public TTGlyph(String glyfName, boolean debug, Glyf currentGlyf, FontFile2 glyfTable, Hmtx currentHmtx, int idx, float unitsPerEm, String baseFontName) {
        block13: {
            this.containsBrokenGlyfData = false;
            this.ttHintingRequired = false;
            this.BP1x = -1;
            this.BP2x = -1;
            this.BP1y = -1;
            this.BP2y = -1;
            this.xtranslateValues = new Vector_Int(5);
            this.ytranslateValues = new Vector_Int(5);
            this.xscaleValues = new Vector_Double(5);
            this.yscaleValues = new Vector_Double(5);
            this.scale01Values = new Vector_Double(5);
            this.scale10Values = new Vector_Double(5);
            this.xscale = 1.0;
            this.yscale = 1.0;
            this.scale01 = 0.0;
            this.scale10 = 0.0;
            this.currentInstructionDepth = Integer.MAX_VALUE;
            this.glyfX = new Vector_Object(5);
            this.glyfY = new Vector_Object(5);
            this.curves = new Vector_Object(5);
            this.contours = new Vector_Object(5);
            this.endPtIndices = new Vector_Int(5);
            this.contourCount = 0;
            this.unitsPerEm = 64.0f;
            this.debug = false;
            this.paths = new Vector_Path(10);
            this.compCount = 1;
            this.isComposite = false;
            this.glyfName = "";
            this.existingXTranslate = 0;
            this.existingYTranslate = 0;
            this.depth = 0;
            this.glyphShape = null;
            this.img = null;
            this.id = 0;
            this.debug = debug;
            this.glyfName = glyfName;
            this.leftSideBearing = currentHmtx.getLeftSideBearing(idx);
            this.unitsPerEm = unitsPerEm;
            int p = currentGlyf.getCharString(idx);
            glyfTable.setPointer(p);
            this.readGlyph(currentGlyf, glyfTable);
            for (int i = 0; i < this.compCount; ++i) {
                int[] pX = (int[])this.glyfX.elementAt(i);
                int[] pY = (int[])this.glyfY.elementAt(i);
                boolean[] onCurve = (boolean[])this.curves.elementAt(i);
                boolean[] endOfContour = (boolean[])this.contours.elementAt(i);
                int endIndex = this.endPtIndices.elementAt(i);
                if (this.isComposite) {
                    this.xtranslate = this.xtranslateValues.elementAt(i);
                    this.ytranslate = this.ytranslateValues.elementAt(i);
                    this.xscale = this.xscaleValues.elementAt(i);
                    this.yscale = this.yscaleValues.elementAt(i);
                    this.scale01 = this.scale01Values.elementAt(i);
                    this.scale10 = this.scale10Values.elementAt(i);
                    if (this.BPoint1 != -1 && this.BPoint2 != -1) {
                        if (this.BP1x == -1 && this.BP2x == -1 && this.BP1y == -1 && this.BP2y == -1) {
                            this.BP1x = pX[this.BPoint1];
                            this.BP1y = pY[this.BPoint1];
                        } else {
                            this.BP2x = pX[this.BPoint2];
                            this.BP2y = pY[this.BPoint2];
                            int xx = this.BP1x - this.BP2x;
                            int yy = this.BP1y - this.BP2y;
                            int count = pX.length;
                            for (int ii = 0; ii < count; ++ii) {
                                pX[ii] = pX[ii] + xx;
                                if (debug) {
                                    System.out.println(pY[ii] + " " + yy + " BP1y=" + this.BP1y + " BP1y=" + this.BP1y);
                                }
                                pY[ii] = pY[ii] + yy;
                            }
                            this.BP1x = -1;
                            this.BP2x = -1;
                            this.BP1y = -1;
                            this.BP2y = -1;
                        }
                    }
                }
                this.createPaths(pX, pY, onCurve, endOfContour, endIndex, debug);
            }
            if (debug) {
                try {
                    System.out.println("debugging" + idx);
                    BufferedImage img = new BufferedImage(700, 700, 2);
                    Graphics2D gg2 = img.createGraphics();
                    for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
                        if (jj == 0) {
                            gg2.setColor(Color.red);
                        } else {
                            gg2.setColor(Color.blue);
                        }
                        gg2.fill(this.paths.elementAt(jj));
                        gg2.draw(this.paths.elementAt(jj).getBounds());
                    }
                }
                catch (Exception e) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception: " + e.getMessage());
                }
            }
        }
    }

    private void readGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.contourCount = currentFontFile.getNextUint16();
        this.minX = (short)currentFontFile.getNextUint16();
        this.minY = (short)currentFontFile.getNextUint16();
        this.maxX = (short)currentFontFile.getNextUint16();
        this.maxY = (short)currentFontFile.getNextUint16();
        if (this.minX > this.maxX || this.minY > this.maxY) {
            return;
        }
        if (this.debug) {
            System.out.println("------------------------------------------------------------");
            System.out.println("min=" + this.minX + ' ' + this.minY + " max=" + this.maxX + ' ' + this.maxY + " contourCount=" + this.contourCount);
        }
        if (this.contourCount != 65535) {
            if (this.contourCount > 0) {
                this.readSimpleGlyph(currentFontFile);
            }
        } else {
            this.compMinX = this.minX;
            this.compMinY = this.minY;
            this.compMaxX = this.maxX;
            this.compMaxY = this.maxY;
            if (this.debug) {
                System.out.println("XXmain=" + this.minX + ' ' + this.minY + ' ' + this.maxX + ' ' + this.maxY);
            }
            this.readComplexGlyph(currentGlyf, currentFontFile);
        }
    }

    private final void readComplexGlyph(Glyf currentGlyf, FontFile2 currentFontFile) {
        this.isComposite = true;
        this.xtranslateValues.pull();
        this.ytranslateValues.pull();
        this.xscaleValues.pull();
        this.yscaleValues.pull();
        this.scale01Values.pull();
        this.scale10Values.pull();
        this.BPoint1 = -1;
        this.BPoint2 = -1;
        boolean WE_HAVE_INSTRUCTIONS = false;
        int count = currentGlyf.getGlypfCount();
        while (true) {
            int flag = currentFontFile.getNextUint16();
            int glyphIndex = currentFontFile.getNextUint16();
            if (this.debug) {
                System.err.println("Index=" + glyphIndex + " flag=" + flag + ' ' + count);
            }
            if (glyphIndex >= count) {
                this.containsBrokenGlyfData = true;
                break;
            }
            boolean ARG_1AND_2_ARE_WORDS = (flag & 1) == 1;
            boolean ARGS_ARE_XY_VALUES = (flag & 2) == 2;
            boolean WE_HAVE_A_SCALE = (flag & 8) == 8;
            boolean WE_HAVE_AN_X_AND_Y_SCALE = (flag & 0x40) == 64;
            boolean WE_HAVE_A_TWO_BY_TWO = (flag & 0x80) == 128;
            boolean bl = WE_HAVE_INSTRUCTIONS = WE_HAVE_INSTRUCTIONS || (flag & 0x100) == 256;
            if (ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextInt16();
                this.ytranslate = currentFontFile.getNextInt16();
            } else if (!ARG_1AND_2_ARE_WORDS && ARGS_ARE_XY_VALUES) {
                this.xtranslate = currentFontFile.getNextint8();
                this.ytranslate = currentFontFile.getNextint8();
            } else if (ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                this.BPoint1 = currentFontFile.getNextUint16();
                this.BPoint2 = currentFontFile.getNextUint16();
                this.xtranslate = 0;
                this.ytranslate = 0;
            } else if (!ARG_1AND_2_ARE_WORDS && !ARGS_ARE_XY_VALUES) {
                this.BPoint1 = currentFontFile.getNextUint8();
                this.BPoint2 = currentFontFile.getNextUint8();
                this.xtranslate = 0;
                this.ytranslate = 0;
            }
            this.xscale = 1.0;
            this.scale01 = 0.0;
            this.scale10 = 0.0;
            this.yscale = 1.0;
            if (WE_HAVE_A_SCALE || WE_HAVE_AN_X_AND_Y_SCALE || WE_HAVE_A_TWO_BY_TWO) {
                if (WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = this.xscale;
                } else if (!WE_HAVE_A_SCALE && WE_HAVE_AN_X_AND_Y_SCALE && !WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = 0.0;
                    this.scale10 = 0.0;
                    this.yscale = currentFontFile.getF2Dot14();
                } else if (!WE_HAVE_A_SCALE && !WE_HAVE_AN_X_AND_Y_SCALE && WE_HAVE_A_TWO_BY_TWO) {
                    this.xscale = currentFontFile.getF2Dot14();
                    this.scale01 = currentFontFile.getF2Dot14();
                    this.scale10 = currentFontFile.getF2Dot14();
                    this.yscale = currentFontFile.getF2Dot14();
                }
            }
            int localX = this.xtranslate;
            int localY = this.ytranslate;
            this.xtranslate += this.existingXTranslate;
            this.ytranslate += this.existingYTranslate;
            this.xtranslateValues.addElement(this.xtranslate);
            this.ytranslateValues.addElement(this.ytranslate);
            this.xscaleValues.addElement(this.xscale);
            this.yscaleValues.addElement(this.yscale);
            this.scale01Values.addElement(this.scale01);
            this.scale10Values.addElement(this.scale10);
            int pointer = currentFontFile.getPointer();
            int p = currentGlyf.getCharString(glyphIndex);
            if (p != -1) {
                if (p < 0) {
                    p = -p;
                }
                currentFontFile.setPointer(p);
                this.existingXTranslate = this.xtranslate;
                this.existingYTranslate = this.ytranslate;
                ++this.depth;
                this.readGlyph(currentGlyf, currentFontFile);
                --this.depth;
                this.existingXTranslate -= localX;
                this.existingYTranslate -= localY;
            } else {
                System.err.println("Wrong value in complex");
            }
            currentFontFile.setPointer(pointer);
            if ((flag & 0x20) == 0) {
                if (WE_HAVE_INSTRUCTIONS) {
                    int instructionLength = currentFontFile.getNextUint16();
                    int[] instructions = new int[instructionLength];
                    for (int i = 0; i < instructionLength; ++i) {
                        instructions[i] = currentFontFile.getNextUint8();
                    }
                    if (this.depth > this.currentInstructionDepth) break;
                    this.instructions = instructions;
                    this.currentInstructionDepth = this.depth;
                    break;
                }
                if (this.depth > this.currentInstructionDepth) break;
                this.instructions = new int[0];
                this.currentInstructionDepth = this.depth;
                break;
            }
            ++this.compCount;
        }
    }

    private void readSimpleGlyph(FontFile2 currentFontFile) {
        int flagCount = 1;
        Vector_Int rawFlags = new Vector_Int(50);
        Vector_Int endPts = new Vector_Int(50);
        Vector_Short XX = new Vector_Short(50);
        Vector_Short Y = new Vector_Short(50);
        if (this.debug) {
            System.out.println("endPoints");
            System.out.println("---------");
        }
        try {
            int lastPt = 0;
            for (int i = 0; i < this.contourCount; ++i) {
                lastPt = currentFontFile.getNextUint16();
                if (this.debug) {
                    System.out.println(i + " " + lastPt);
                }
                endPts.addElement(lastPt);
            }
            if (currentFontFile.hasValuesLeft()) {
                int i;
                int flag;
                int i2;
                int instructionLength = currentFontFile.getNextUint16();
                int[] instructions = new int[instructionLength];
                for (int i3 = 0; i3 < instructionLength; ++i3) {
                    instructions[i3] = currentFontFile.getNextUint8();
                }
                if (this.depth < this.currentInstructionDepth) {
                    this.instructions = instructions;
                }
                if (this.debug) {
                    System.out.println("Instructions");
                    System.out.println("------------");
                    System.out.println("count=" + instructionLength);
                }
                int count = lastPt + 1;
                for (i2 = 0; i2 < count; ++i2) {
                    if (currentFontFile.getBytesLeft() < 1) {
                        return;
                    }
                    flag = currentFontFile.getNextUint8();
                    rawFlags.addElement(flag);
                    ++flagCount;
                    if ((flag & 8) != 8) continue;
                    int repeatCount = currentFontFile.getNextUint8();
                    for (int r = 1; r <= repeatCount; ++r) {
                        rawFlags.addElement(flag);
                        ++flagCount;
                    }
                    i2 += repeatCount;
                }
                for (i2 = 0; i2 < count; ++i2) {
                    short x1;
                    flag = rawFlags.elementAt(i2);
                    if ((flag & 0x10) != 0) {
                        if ((flag & 2) != 0) {
                            x1 = (short)currentFontFile.getNextUint8();
                            XX.addElement(x1);
                            continue;
                        }
                        XX.addElement((short)0);
                        continue;
                    }
                    if ((flag & 2) != 0) {
                        x1 = (short)(-currentFontFile.getNextUint8());
                        XX.addElement(x1);
                        continue;
                    }
                    x1 = currentFontFile.getNextSignedInt16();
                    XX.addElement(x1);
                }
                for (i2 = 0; i2 < count; ++i2) {
                    flag = rawFlags.elementAt(i2);
                    if ((flag & 0x20) != 0) {
                        if ((flag & 4) != 0) {
                            if (currentFontFile.getBytesLeft() < 1) {
                                return;
                            }
                            Y.addElement((short)currentFontFile.getNextUint8());
                            continue;
                        }
                        Y.addElement((short)0);
                        continue;
                    }
                    if ((flag & 4) != 0) {
                        Y.addElement((short)(-currentFontFile.getNextUint8()));
                        continue;
                    }
                    short val = currentFontFile.getNextSignedInt16();
                    Y.addElement(val);
                }
                int endPtIndex = 0;
                int x = 0;
                int y = 0;
                int[] flags = rawFlags.get();
                int[] endPtsOfContours = endPts.get();
                short[] XPoints = XX.get();
                short[] YPoints = Y.get();
                count = XPoints.length;
                int[] pX = new int[count + 2];
                int[] pY = new int[count + 2];
                boolean[] onCurve = new boolean[count + 2];
                boolean[] endOfContour = new boolean[count + 2];
                int endIndex = 0;
                if (this.debug) {
                    System.out.println("Points");
                    System.out.println("------");
                }
                for (i = 0; i < count; ++i) {
                    boolean endPt;
                    boolean bl = endPt = endPtsOfContours[endPtIndex] == i;
                    if (endPt) {
                        ++endPtIndex;
                        endIndex = i + 1;
                    }
                    pX[i] = x += XPoints[i];
                    pY[i] = y += YPoints[i];
                    onCurve[i] = i < flagCount && (flags[i] & 1) != 0;
                    endOfContour[i] = endPt;
                    if (!this.debug) continue;
                    System.out.println(i + " " + pX[i] + ' ' + pY[i] + " on curve=" + onCurve[i] + " endOfContour[i]=" + endOfContour[i]);
                }
                for (i = 0; i < pX.length; ++i) {
                    int lX = pX[i];
                    int lY = pY[i];
                    pX[i] = !this.isComposite ? (!useHinting ? (int)((float)lX / this.unitsPerEm) : lX) : (!useHinting ? (int)(((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.xscale + (double)lY * this.scale10 + (double)this.xtranslate));
                    if (!this.isComposite) {
                        if (!useHinting) {
                            pY[i] = (int)((float)lY / this.unitsPerEm);
                            continue;
                        }
                        pY[i] = lY;
                        continue;
                    }
                    pY[i] = !useHinting ? (int)(((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate) / (double)this.unitsPerEm) : (int)((double)lX * this.scale01 + (double)lY * this.yscale + (double)this.ytranslate);
                }
                this.glyfX.addElement(pX);
                this.glyfY.addElement(pY);
                this.curves.addElement(onCurve);
                this.contours.addElement(endOfContour);
                this.endPtIndices.addElement(endIndex);
            }
        }
        catch (Exception e) {
            return;
        }
    }

    @Override
    public void render(int type, Graphics2D g2, float scaling, boolean isFormGlyph) {
        AffineTransform restore = g2.getTransform();
        BasicStroke oldStroke = (BasicStroke)g2.getStroke();
        float strokeWidth = oldStroke.getLineWidth();
        if (strokeWidth < 0.0f) {
            strokeWidth = -strokeWidth;
        }
        if (useHinting) {
            g2.scale(0.01, 0.01);
            strokeWidth *= 100.0f;
        }
        g2.setStroke(new BasicStroke(strokeWidth, 0, 1, oldStroke.getMiterLimit(), oldStroke.getDashArray(), oldStroke.getDashPhase()));
        for (int jj = 0; jj < this.paths.size() - 1; ++jj) {
            if ((type & 2) == 2) {
                g2.fill(this.paths.elementAt(jj));
                continue;
            }
            if ((type & 1) != 1) continue;
            g2.draw(this.paths.elementAt(jj));
        }
        if (useHinting) {
            g2.setStroke(oldStroke);
            g2.setTransform(restore);
        }
    }

    @Override
    public Area getShape() {
        if (this.glyphShape == null) {
            GeneralPath path = this.paths.elementAt(0);
            for (int jj = 1; jj < this.paths.size() - 1; ++jj) {
                path.append(this.paths.elementAt(jj), false);
            }
            if (path == null) {
                return null;
            }
            this.glyphShape = new Area(path);
        }
        return this.glyphShape;
    }

    @Override
    public String getGlyphName() {
        return null;
    }

    public void scaler(int[] pX, int[] pY) {
        this.scaledX = new int[pX.length];
        this.scaledY = new int[pY.length];
        double scale = this.pixelSize / (double)(this.unitsPerEm * 1000.0f) * 64.0;
        for (int i = 0; i < pX.length; ++i) {
            this.scaledX[i] = (int)(scale * (double)pX[i] + 0.5);
            this.scaledY[i] = (int)(scale * (double)pY[i] + 0.5);
        }
        this.scaledX[pX.length - 2] = 0;
        this.scaledY[pY.length - 2] = 0;
        this.scaledX[pX.length - 1] = (int)(scale * (double)this.leftSideBearing + 0.5);
        this.scaledY[pY.length - 1] = 0;
    }

    public void createPaths(int[] pX, int[] pY, boolean[] onCurve, boolean[] endOfContour, int endIndex, boolean debug) {
        if (endOfContour == null) {
            return;
        }
        int ptCount = endOfContour.length;
        int start = 0;
        int firstPt = -1;
        for (int ii = 0; ii < ptCount; ++ii) {
            if (endOfContour[ii]) {
                if (!(firstPt == -1 || onCurve[start] && onCurve[ii])) {
                    int diff = firstPt - start;
                    int pXlength = pX.length;
                    int[] old_pX = new int[pXlength];
                    System.arraycopy(pX, 0, old_pX, 0, pXlength);
                    int[] old_pY = new int[pXlength];
                    System.arraycopy(pY, 0, old_pY, 0, pXlength);
                    boolean[] old_onCurve = new boolean[pXlength];
                    System.arraycopy(onCurve, 0, old_onCurve, 0, pXlength);
                    for (int oldPos = start; oldPos < ii + 1; ++oldPos) {
                        int newPos = oldPos + diff;
                        if (newPos > ii) {
                            newPos -= ii - start + 1;
                        }
                        pX[oldPos] = old_pX[newPos];
                        pY[oldPos] = old_pY[newPos];
                        onCurve[oldPos] = old_onCurve[newPos];
                    }
                }
                start = ii + 1;
                firstPt = -1;
                continue;
            }
            if (!onCurve[ii] || firstPt != -1) continue;
            firstPt = ii;
        }
        boolean isFirstDraw = true;
        GeneralPath current_path = new GeneralPath(1);
        int c = pX.length;
        int fc = -1;
        for (int jj = 0; jj < c; ++jj) {
            if (!endOfContour[jj]) continue;
            fc = jj + 1;
            jj = c;
        }
        int x2 = 0;
        int y2 = 0;
        int x3 = 0;
        int y3 = 0;
        int x1 = pX[0];
        int y1 = pY[0];
        if (this.debug) {
            System.out.println(pX[0] + " " + pY[0] + " move to x1,y1=" + x1 + ' ' + y1);
        }
        current_path.moveTo(x1, y1);
        if (this.debug) {
            System.out.println("first contour=" + fc + "====================================" + pX[0] + ' ' + pY[0]);
        }
        int xs = 0;
        int ys = 0;
        int lc = 0;
        boolean isEnd = false;
        for (int j = 0; j < endIndex; ++j) {
            int p = j % fc;
            int p1 = (j + 1) % fc;
            int p2 = (j + 2) % fc;
            int pm1 = (j - 1) % fc;
            if (j == 0) {
                pm1 = fc - 1;
            }
            if (p1 < lc) {
                p1 += lc;
            }
            if (p2 < lc) {
                p2 += lc;
            }
            if (debug) {
                System.out.println("points=" + lc + '/' + fc + ' ' + pm1 + ' ' + p + ' ' + p1 + ' ' + p2 + " j=" + j + " endOfContour[j]=" + endOfContour[j]);
            }
            if (endOfContour[j]) {
                isEnd = true;
                if (onCurve[fc]) {
                    xs = pX[fc];
                    ys = pY[fc];
                } else {
                    xs = pX[j + 1];
                    ys = pY[j + 1];
                }
                lc = fc;
                for (int jj = j + 1; jj < c; ++jj) {
                    if (!endOfContour[jj]) continue;
                    fc = jj + 1;
                    jj = c;
                }
                if (debug) {
                    System.out.println("End of contour. next=" + j + ' ' + fc + ' ' + lc);
                }
            }
            if (debug) {
                if (j > 0) {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j-1=" + endOfContour[j - 1] + " j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                } else {
                    System.out.println("curves=" + onCurve[p] + ' ' + onCurve[p1] + ' ' + onCurve[p2] + " EndOfContour j=" + endOfContour[j] + " j+1=" + endOfContour[j + 1]);
                }
            }
            if (lc == fc && onCurve[p]) {
                j = c;
                if (!debug) continue;
                System.out.println("last 2 match");
                continue;
            }
            if (debug) {
                System.out.println(fc + " " + pm1 + ' ' + p + ' ' + p1 + ' ' + p2);
            }
            if (onCurve[p] && onCurve[p1]) {
                x3 = pX[p1];
                y3 = pY[p1];
                current_path.lineTo(x3, y3);
                if (debug) {
                    System.out.println(p + " pt,pt " + x3 + ' ' + y3 + " (lineTo)");
                }
                isFirstDraw = false;
            } else if (j < c - 3 && (fc - lc > 1 || fc == lc)) {
                boolean checkEnd = false;
                if (onCurve[p] && !onCurve[p1] && onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = pX[p2];
                    y3 = pY[p2];
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (onCurve[p] && !onCurve[p1] && !onCurve[p2]) {
                    x1 = pX[p];
                    y1 = pY[p];
                    x2 = pX[p1];
                    y2 = pY[p1];
                    x3 = TTGlyph.midPt(pX[p1], pX[p2]);
                    y3 = TTGlyph.midPt(pY[p1], pY[p2]);
                    ++j;
                    checkEnd = true;
                    if (debug) {
                        System.out.println(p + " pt,cv,cv " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!(onCurve[p] || onCurve[p1] || endOfContour[p2] && fc - p2 != 1)) {
                    x1 = TTGlyph.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyph.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = TTGlyph.midPt(pX[p], pX[p1]);
                    y3 = TTGlyph.midPt(pY[p], pY[p1]);
                    if (debug) {
                        System.out.println(p + " cv,cv1 " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                } else if (!onCurve[p] && onCurve[p1]) {
                    x1 = TTGlyph.midPt(pX[pm1], pX[p]);
                    y1 = TTGlyph.midPt(pY[pm1], pY[p]);
                    x2 = pX[p];
                    y2 = pY[p];
                    x3 = pX[p1];
                    y3 = pY[p1];
                    if (debug) {
                        System.out.println(p + " cv,pt " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                    }
                }
                if (isFirstDraw) {
                    current_path.moveTo(x1, y1);
                    isFirstDraw = false;
                    if (debug) {
                        System.out.println("first draw move to " + x1 + ' ' + y1);
                    }
                }
                if (!endOfContour[p] || p <= 0 || !endOfContour[p - 1]) {
                    current_path.curveTo(x1, y1, x2, y2, x3, y3);
                }
                if (debug) {
                    System.out.println("curveto " + x1 + ' ' + y1 + ' ' + x2 + ' ' + y2 + ' ' + x3 + ' ' + y3);
                }
                if (checkEnd && endOfContour[j]) {
                    isEnd = true;
                    xs = pX[fc];
                    ys = pY[fc];
                    lc = fc;
                    for (int jj = j + 1; jj < c; ++jj) {
                        if (!endOfContour[jj]) continue;
                        fc = jj + 1;
                        jj = c;
                    }
                    if (debug) {
                        System.out.println("Curve");
                    }
                }
            }
            if (endOfContour[p]) {
                current_path.closePath();
            }
            if (debug) {
                System.out.println("x2 " + xs + ' ' + ys + ' ' + isEnd);
            }
            if (isEnd) {
                current_path.moveTo(xs, ys);
                isEnd = false;
                if (debug) {
                    System.out.println("Move to " + xs + ' ' + ys);
                }
            }
            if (!debug) continue;
            try {
                if (this.img == null) {
                    this.img = new BufferedImage(800, 800, 2);
                }
                Graphics2D g2 = this.img.createGraphics();
                g2.setColor(Color.green);
                g2.draw(current_path);
                String key = String.valueOf(p);
                ShowGUIMessage.showGUIMessage(key, this.img, key);
                continue;
            }
            catch (Exception e) {
                if (!LogWriter.isOutput()) continue;
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        this.paths.addElement(current_path);
        if (debug) {
            System.out.println("Ends at " + x1 + ' ' + y1 + " x=" + this.minX + ',' + this.maxX + " y=" + this.minY + ',' + this.maxY + " glyph x=" + this.compMinX + ',' + this.compMaxX + " y=" + this.compMinY + ',' + this.compMaxY);
        }
    }

    private static int midPt(int a, int b) {
        return a + (b - a) / 2;
    }

    @Override
    public float getmaxWidth() {
        return 0.0f;
    }

    @Override
    public int getmaxHeight() {
        return 0;
    }

    @Override
    public void setT3Colors(PdfPaint strokeColor, PdfPaint nonstrokeColor, boolean lockColours) {
    }

    @Override
    public boolean ignoreColors() {
        return false;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void setID(int id) {
        this.id = id;
    }

    public void flushArea() {
        this.glyphShape = null;
    }

    @Override
    public void setWidth(float width) {
    }

    @Override
    public int getFontBB(int type) {
        if (this.isComposite) {
            if (type == 1) {
                return this.compMinX;
            }
            if (type == 2) {
                return this.compMinY;
            }
            if (type == 3) {
                return this.compMaxX;
            }
            if (type == 4) {
                return this.compMaxY;
            }
            return 0;
        }
        if (type == 1) {
            return this.minX;
        }
        if (type == 2) {
            return this.minY;
        }
        if (type == 3) {
            return this.maxX;
        }
        if (type == 4) {
            return this.maxY;
        }
        return 0;
    }

    @Override
    public void setStrokedOnly(boolean b) {
    }

    @Override
    public boolean containsBrokenData() {
        return this.containsBrokenGlyfData;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TTGlyph [containsBrokenGlyfData=");
        builder.append(this.containsBrokenGlyfData);
        builder.append(", ttHintingRequired=");
        builder.append(this.ttHintingRequired);
        builder.append(", minX=");
        builder.append(this.minX);
        builder.append(", minY=");
        builder.append(this.minY);
        builder.append(", maxX=");
        builder.append(this.maxX);
        builder.append(", maxY=");
        builder.append(this.maxY);
        builder.append(", BPoint1=");
        builder.append(this.BPoint1);
        builder.append(", BPoint2=");
        builder.append(this.BPoint2);
        builder.append(", BP1x=");
        builder.append(this.BP1x);
        builder.append(", BP2x=");
        builder.append(this.BP2x);
        builder.append(", BP1y=");
        builder.append(this.BP1y);
        builder.append(", BP2y=");
        builder.append(this.BP2y);
        builder.append(", compMinX=");
        builder.append(this.compMinX);
        builder.append(", compMinY=");
        builder.append(this.compMinY);
        builder.append(", compMaxX=");
        builder.append(this.compMaxX);
        builder.append(", compMaxY=");
        builder.append(this.compMaxY);
        builder.append(", ");
        if (this.scaledX != null) {
            builder.append("scaledX=");
            builder.append(Arrays.toString(this.scaledX));
            builder.append(", ");
        }
        if (this.scaledY != null) {
            builder.append("scaledY=");
            builder.append(Arrays.toString(this.scaledY));
            builder.append(", ");
        }
        builder.append("leftSideBearing=");
        builder.append(this.leftSideBearing);
        builder.append(", ");
        if (this.xtranslateValues != null) {
            builder.append("xtranslateValues=");
            builder.append(this.xtranslateValues);
            builder.append(", ");
        }
        if (this.ytranslateValues != null) {
            builder.append("ytranslateValues=");
            builder.append(this.ytranslateValues);
            builder.append(", ");
        }
        if (this.xscaleValues != null) {
            builder.append("xscaleValues=");
            builder.append(this.xscaleValues);
            builder.append(", ");
        }
        if (this.yscaleValues != null) {
            builder.append("yscaleValues=");
            builder.append(this.yscaleValues);
            builder.append(", ");
        }
        if (this.scale01Values != null) {
            builder.append("scale01Values=");
            builder.append(this.scale01Values);
            builder.append(", ");
        }
        if (this.scale10Values != null) {
            builder.append("scale10Values=");
            builder.append(this.scale10Values);
            builder.append(", ");
        }
        builder.append("xtranslate=");
        builder.append(this.xtranslate);
        builder.append(", ytranslate=");
        builder.append(this.ytranslate);
        builder.append(", xscale=");
        builder.append(this.xscale);
        builder.append(", yscale=");
        builder.append(this.yscale);
        builder.append(", scale01=");
        builder.append(this.scale01);
        builder.append(", scale10=");
        builder.append(this.scale10);
        builder.append(", ");
        if (this.instructions != null) {
            builder.append("instructions=");
            builder.append(Arrays.toString(this.instructions));
            builder.append(", ");
        }
        builder.append("currentInstructionDepth=");
        builder.append(this.currentInstructionDepth);
        builder.append(", ");
        if (this.glyfX != null) {
            builder.append("glyfX=");
            builder.append(this.glyfX);
            builder.append(", ");
        }
        if (this.glyfY != null) {
            builder.append("glyfY=");
            builder.append(this.glyfY);
            builder.append(", ");
        }
        if (this.curves != null) {
            builder.append("curves=");
            builder.append(this.curves);
            builder.append(", ");
        }
        if (this.contours != null) {
            builder.append("contours=");
            builder.append(this.contours);
            builder.append(", ");
        }
        if (this.endPtIndices != null) {
            builder.append("endPtIndices=");
            builder.append(this.endPtIndices);
            builder.append(", ");
        }
        builder.append("contourCount=");
        builder.append(this.contourCount);
        builder.append(", unitsPerEm=");
        builder.append(this.unitsPerEm);
        builder.append(", debug=");
        builder.append(this.debug);
        builder.append(", compCount=");
        builder.append(this.compCount);
        builder.append(", isComposite=");
        builder.append(this.isComposite);
        builder.append(", ");
        if (this.glyfName != null) {
            builder.append("glyfName=");
            builder.append(this.glyfName);
            builder.append(", ");
        }
        builder.append("pixelSize=");
        builder.append(this.pixelSize);
        builder.append(", existingXTranslate=");
        builder.append(this.existingXTranslate);
        builder.append(", existingYTranslate=");
        builder.append(this.existingYTranslate);
        builder.append(", depth=");
        builder.append(this.depth);
        builder.append(", ");
        if (this.glyphShape != null) {
            builder.append("glyphShape=");
            builder.append(this.glyphShape);
            builder.append(", ");
        }
        if (this.img != null) {
            builder.append("img=");
            builder.append(this.img);
            builder.append(", ");
        }
        builder.append("id=");
        builder.append(this.id);
        builder.append("]");
        return builder.toString();
    }

    static {
        String value = System.getProperty("org.jpedal.useTTFontHinting");
        if (value != null) {
            useHinting = value.toLowerCase().equals("true");
        }
        testedFonts = new HashSet();
    }
}

