/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.conversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.fonts.tt.conversion.FontTableWriter;
import org.jpedal.fonts.tt.conversion.FontWriter;
import org.jpedal.utils.Sorts;

public class CMAPWriter
extends CMAP
implements FontTableWriter {
    private static final long serialVersionUID = -923078471161905124L;
    int minCharCode = 65536;
    int maxCharCode = 0;
    String fontName;
    private PdfFont originalFont;

    public CMAPWriter(FontFile2 currentFontFile, int startPointer, Glyf currentGlyf) {
        super(currentFontFile, startPointer, currentGlyf);
    }

    private int createFormat0MapForTT(PdfJavaGlyphs glyphs) {
        int z;
        TTGlyphs ttGlyphs = (TTGlyphs)glyphs;
        CMAP currentCmap = (CMAP)ttGlyphs.getTable(2);
        HashMap<Integer, Integer> glyphMap = null;
        if (currentCmap == null) {
            glyphMap = new HashMap<Integer, Integer>();
            if (this.originalFont.getToUnicode() == null) {
                int gCount = glyphs.getGlyphCount();
                for (int z2 = 0; z2 < gCount; ++z2) {
                    glyphMap.put(z2, z2);
                }
            } else {
                for (z = 0; z < 65536; ++z) {
                    String str;
                    int adjValue;
                    if (this.originalFont.getUnicodeMapping(z) == null || (adjValue = this.getAdjustedUniValue(str = this.originalFont.getUnicodeMapping(z))) < 0) continue;
                    glyphMap.put(adjValue, z);
                }
            }
        } else {
            glyphMap = currentCmap.buildCharStringTable();
        }
        for (z = 0; z < 256; ++z) {
            this.glyphIndexToChar[1][z] = glyphMap.get(z) != null ? (Integer)glyphMap.get(z) : 0;
        }
        return 262;
    }

    /*
     * WARNING - void declaration
     */
    private int createFormat4MapForTT(PdfJavaGlyphs glyphs) {
        void var11_29;
        void var11_27;
        void var11_25;
        void var11_23;
        TTGlyphs ttGlyphs = (TTGlyphs)glyphs;
        CMAP currentCmap = (CMAP)ttGlyphs.getTable(2);
        HashMap<Integer, Integer> glyphMap = null;
        if (currentCmap == null) {
            glyphMap = new HashMap<Integer, Integer>();
            if (this.originalFont.getToUnicode() == null) {
                int gCount = glyphs.getGlyphCount();
                for (int z2 = 0; z2 < gCount; ++z2) {
                    glyphMap.put(z2, z2);
                }
            } else {
                for (int z3 = 0; z3 < 65536; ++z3) {
                    String str;
                    int adjValue;
                    if (this.originalFont.getUnicodeMapping(z3) == null || (adjValue = this.getAdjustedUniValue(str = this.originalFont.getUnicodeMapping(z3))) < 0) continue;
                    glyphMap.put(adjValue, z3);
                }
                if (glyphMap.get(32) == null) {
                    Object[] keys = ttGlyphs.getCharStrings().keySet().toArray();
                    Hmtx hmtx = (Hmtx)ttGlyphs.getTable(6);
                    int currentGlyph = 0;
                    for (Object object : keys) {
                        while (currentGlyph < this.originalFont.getGlyphData().getGlyphCount() && hmtx.getUnscaledWidth(currentGlyph) == 0.0f) {
                            ++currentGlyph;
                        }
                        if (currentGlyph != (Integer)object) continue;
                        ++currentGlyph;
                    }
                    glyphMap.put(32, currentGlyph);
                }
            }
        } else {
            glyphMap = currentCmap.buildCharStringTable();
        }
        int segCount = 0;
        HashMap<Integer, Integer> uniToRawMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> uniToCharCodeMap = new HashMap<Integer, Integer>();
        HashMap<Integer, Integer> pointerCodeMap = new HashMap<Integer, Integer>();
        ArrayList pointerList = new ArrayList();
        for (Object k : glyphMap.keySet()) {
            int k2 = (Integer)k;
            int v = (Integer)glyphMap.get(k2);
            int uniValue = currentCmap == null || currentCmap.hasFormat4() ? k2 : (this.originalFont.getUnicodeMapping(k2) != null ? (int)this.originalFont.getUnicodeMapping(k2).charAt(0) : k2);
            uniToRawMap.put(uniValue, k2);
            uniToCharCodeMap.put(uniValue, v);
        }
        Object[] uniToRawMapKeys = uniToRawMap.keySet().toArray();
        Arrays.sort(uniToRawMapKeys);
        segCount = uniToRawMap.size() + 1;
        this.endCode = new int[segCount];
        this.endCode[segCount - 1] = 65535;
        boolean bl = false;
        while (var11_23 < segCount - 1) {
            this.endCode[var11_23] = (Integer)uniToRawMapKeys[var11_23];
            ++var11_23;
        }
        this.startCode = new int[segCount];
        this.startCode[segCount - 1] = 65535;
        boolean bl2 = false;
        while (var11_25 < segCount - 1) {
            this.startCode[var11_25] = (Integer)uniToRawMapKeys[var11_25];
            ++var11_25;
        }
        this.idDelta = new int[segCount];
        this.idDelta[segCount - 1] = 1;
        boolean bl3 = false;
        while (var11_27 < segCount - 1) {
            this.idDelta[var11_27] = (Integer)uniToCharCodeMap.get(this.startCode[var11_27]) - this.startCode[var11_27];
            if (this.idDelta[var11_27] >= 0) {
                this.idDelta[var11_27] = 0;
                pointerCodeMap.put((int)var11_27, 2 * (segCount - var11_27) + 2 * pointerList.size());
                pointerList.add(uniToCharCodeMap.get(this.startCode[var11_27]));
            }
            ++var11_27;
        }
        this.idRangeOffset = new int[segCount];
        this.idRangeOffset[segCount - 1] = 0;
        boolean bl4 = false;
        while (var11_29 < segCount - 1) {
            this.idRangeOffset[var11_29] = pointerCodeMap.get((int)var11_29) != null ? (Integer)pointerCodeMap.get((int)var11_29) : 0;
            ++var11_29;
        }
        int n = segCount * 2;
        int searchRange = (int)(2.0 * Math.pow(2.0, Math.floor(Math.log(segCount) / Math.log(2.0))));
        int entrySelector = (int)(Math.log(searchRange / 2) / Math.log(2.0));
        int rangeShift = 2 * segCount - searchRange;
        this.CMAPreserved = new int[]{0, 0, 0};
        this.CMAPsegCount = new int[]{n, 0, n};
        this.CMAPsearchRange = new int[]{searchRange, 0, searchRange};
        this.CMAPentrySelector = new int[]{entrySelector, 0, entrySelector};
        this.CMAPrangeShift = new int[]{rangeShift, 0, rangeShift};
        if (pointerList.size() > 0) {
            this.glyphIdArray = new int[pointerList.size()];
            for (int z4 = 0; z4 < this.glyphIdArray.length; ++z4) {
                this.glyphIdArray[z4] = (Integer)pointerList.get(z4);
            }
        }
        return 16 + segCount * 8 + pointerList.size() * 2;
    }

    private int createFormat4Map(PdfJavaGlyphs glyphs, boolean is1C, String[] glyphList) {
        int[] unicodeToGlyph = new int[65536];
        for (int i = 0; i < unicodeToGlyph.length; ++i) {
            unicodeToGlyph[i] = Integer.MAX_VALUE;
        }
        if (this.originalFont.getFontType() == 1217103210) {
            int count = glyphList.length;
            for (int ii = 0; ii < count; ++ii) {
                int ptr;
                if (glyphList[ii] == null || (ptr = Integer.parseInt(glyphList[ii])) <= 0) continue;
                unicodeToGlyph[ii] = ptr;
            }
        } else {
            this.getNonTTGlyphData(glyphs, is1C, glyphList, unicodeToGlyph);
        }
        int[] rangeStart = new int[40000];
        int[] rangeEnd = new int[40000];
        int segCount = 0;
        boolean inRange = false;
        for (int i = 0; i < 65536; ++i) {
            if (inRange && unicodeToGlyph[i] == Integer.MAX_VALUE) {
                inRange = false;
                rangeEnd[segCount] = i - 1;
                ++segCount;
                continue;
            }
            if (inRange || unicodeToGlyph[i] == Integer.MAX_VALUE) continue;
            inRange = true;
            rangeStart[segCount] = i;
        }
        if (unicodeToGlyph[65533] == Integer.MAX_VALUE) {
            rangeStart[segCount] = 65533;
            rangeEnd[segCount] = 65533;
            unicodeToGlyph[65533] = 1;
            ++segCount;
        }
        if (unicodeToGlyph[65535] == Integer.MAX_VALUE) {
            rangeStart[segCount] = 65535;
            rangeEnd[segCount] = 65535;
            unicodeToGlyph[65535] = 1;
            ++segCount;
        }
        int segX2 = segCount * 2;
        this.CMAPsegCount = new int[]{segX2, 0, segX2};
        int searchRange = 1;
        while (searchRange * 2 <= segCount) {
            searchRange *= 2;
        }
        this.CMAPsearchRange = new int[]{searchRange *= 2, 0, searchRange};
        int entrySelector = 0;
        int working = searchRange / 2;
        while (working > 1) {
            working /= 2;
            ++entrySelector;
        }
        this.CMAPentrySelector = new int[]{entrySelector, 0, entrySelector};
        int rangeShift = segX2 - searchRange;
        this.CMAPrangeShift = new int[]{rangeShift, 0, rangeShift};
        this.endCode = rangeEnd;
        this.CMAPreserved = new int[]{0, 0, 0};
        this.startCode = rangeStart;
        this.idRangeOffset = new int[segCount];
        int glyphIdArrayLength = 0;
        block5: for (int i = 0; i < segCount; ++i) {
            int diff = unicodeToGlyph[rangeStart[i]] - rangeStart[i];
            for (int j = rangeStart[i] + 1; j <= rangeEnd[i]; ++j) {
                if (unicodeToGlyph[j] - j == diff) continue;
                this.idRangeOffset[i] = -1;
                glyphIdArrayLength += rangeEnd[i] + 1 - rangeStart[i];
                continue block5;
            }
        }
        this.glyphIdArray = new int[glyphIdArrayLength];
        this.idDelta = new int[segCount];
        int addressPointer = 16 + segCount * 8;
        int arrayPointer = 0;
        for (int i = 0; i < this.idRangeOffset.length; ++i) {
            if (this.idRangeOffset[i] == 0) {
                this.idDelta[i] = unicodeToGlyph[rangeStart[i]] - rangeStart[i] - 1;
                continue;
            }
            this.idRangeOffset[i] = addressPointer - (16 + segCount * 6 + i * 2);
            for (int j = rangeStart[i]; j <= rangeEnd[i]; ++j) {
                this.glyphIdArray[arrayPointer] = unicodeToGlyph[j] - 1;
                addressPointer += 2;
                ++arrayPointer;
            }
        }
        return 16 + segCount * 8 + glyphIdArrayLength * 2;
    }

    private void getNonTTGlyphData(PdfJavaGlyphs glyphs, boolean is1C, String[] glyphList, int[] unicodeToGlyph) {
        int cid = 0;
        for (int i = 0; i < glyphs.getGlyphCount() + 1; ++i) {
            int uc;
            String val = null;
            if (this.originalFont != null && this.originalFont.getGlyphData().isIdentity() && this.originalFont.hasToUnicode() && i > 1) {
                val = this.originalFont.getUnicodeMapping(cid);
                while (val == null && cid < 55296) {
                    val = this.originalFont.getUnicodeMapping(++cid);
                }
                if (val != null) {
                    unicodeToGlyph[val.charAt((int)0)] = i;
                }
                ++cid;
                continue;
            }
            if (val == null && is1C) {
                val = glyphs.getIndexForCharString(i);
            } else if (val == null && i < glyphList.length) {
                val = glyphList[i];
            }
            if (val == null || (uc = StandardFonts.getIDForGlyphName(this.fontName, val)) < 0 || uc >= unicodeToGlyph.length) continue;
            unicodeToGlyph[uc] = is1C ? i : i + 1;
        }
    }

    public CMAPWriter(String fontName, PdfFont currentFontData, PdfFont originalFont, PdfJavaGlyphs glyphs, String[] glyphList) {
        this.fontName = fontName;
        this.originalFont = originalFont;
        this.numberSubtables = 3;
        this.CMAPformats = new int[]{4, 0, 4};
        this.glyphIndexToChar = new int[3][256];
        this.platformID = new int[]{0, 1, 3};
        this.platformSpecificID = new int[]{3, 0, 1};
        this.CMAPlang = new int[]{0, 0, 0};
        int format4Length = 0;
        if (originalFont.getFontType() == 1217103210) {
            format4Length = this.createFormat4MapForTT(glyphs);
            this.createFormat0MapForTT(glyphs);
        } else {
            format4Length = this.createFormat4Map(glyphs, currentFontData.is1C(), glyphList);
            int enc = 0;
            StandardFonts.checkLoaded(enc);
            for (int i = 0; i < glyphs.getGlyphCount() + 1; ++i) {
                String val = null;
                if (currentFontData.is1C()) {
                    val = glyphs.getIndexForCharString(i);
                } else if (i < glyphList.length) {
                    val = glyphList[i];
                }
                if (val == null) continue;
                int id = StandardFonts.lookupCharacterIndex(val, 0);
                int glyph = i;
                if (currentFontData.is1C()) {
                    --glyph;
                    if (i == 1) {
                        glyph = 1;
                    }
                }
                if (id < 0 || id >= 256) continue;
                this.glyphIndexToChar[1][id] = glyph;
            }
        }
        this.CMAPlength = new int[]{format4Length, 262, format4Length};
        this.CMAPsubtables = new int[]{28, 28 + format4Length * 2, 28 + format4Length};
    }

    @Override
    public byte[] writeTable() throws IOException {
        int i;
        int j;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        boolean debug = false;
        int numberSubtables = this.numberSubtables;
        ArrayList<Integer> tables = new ArrayList<Integer>();
        for (int i2 = 0; i2 < numberSubtables; ++i2) {
            tables.add(i2);
        }
        bos.write(FontWriter.setNextUint16(this.id));
        bos.write(FontWriter.setNextUint16(numberSubtables));
        for (int j2 = 0; j2 < numberSubtables; ++j2) {
            boolean isDuplicate;
            int i3 = (Integer)tables.get(j2);
            boolean bl = isDuplicate = i3 < 0;
            if (i3 < 0) {
                i3 = -i3;
            }
            if (isDuplicate) {
                bos.write(FontWriter.setNextUint16(0));
                bos.write(FontWriter.setNextUint16(3));
            } else {
                bos.write(FontWriter.setNextUint16(this.platformID[i3]));
                bos.write(FontWriter.setNextUint16(this.platformSpecificID[i3]));
            }
            bos.write(FontWriter.setNextUint32(this.CMAPsubtables[i3]));
        }
        int[] offset = new int[numberSubtables];
        int[] order = new int[numberSubtables];
        for (j = 0; j < numberSubtables; ++j) {
            i = (Integer)tables.get(j);
            if (i < 0) {
                i = -i;
            }
            offset[i] = this.CMAPsubtables[i];
            order[j] = i;
        }
        order = Sorts.quicksort(offset, order);
        for (j = 0; j < numberSubtables; ++j) {
            int jj;
            i = order[j];
            while (bos.size() < this.CMAPsubtables[i]) {
                bos.write(0);
            }
            bos.write(FontWriter.setNextUint16(this.CMAPformats[i]));
            bos.write(FontWriter.setNextUint16(this.CMAPlength[i]));
            bos.write(FontWriter.setNextUint16(this.CMAPlang[i]));
            if (this.CMAPformats[i] == 0 && this.CMAPlength[i] == 262) {
                for (int glyphNum = 0; glyphNum < 256; ++glyphNum) {
                    bos.write(FontWriter.setNextUint8(this.glyphIndexToChar[i][glyphNum]));
                }
                continue;
            }
            if (this.CMAPformats[i] != 4) continue;
            int segCount = this.CMAPsegCount[i] / 2;
            bos.write(FontWriter.setNextUint16(this.CMAPsegCount[i]));
            bos.write(FontWriter.setNextUint16(this.CMAPsearchRange[i]));
            bos.write(FontWriter.setNextUint16(this.CMAPentrySelector[i]));
            bos.write(FontWriter.setNextUint16(this.CMAPrangeShift[i]));
            for (jj = 0; jj < segCount; ++jj) {
                bos.write(FontWriter.setNextUint16(this.endCode[jj]));
            }
            bos.write(FontWriter.setNextUint16(this.CMAPreserved[i]));
            for (jj = 0; jj < segCount; ++jj) {
                bos.write(FontWriter.setNextUint16(this.startCode[jj]));
            }
            for (jj = 0; jj < segCount; ++jj) {
                bos.write(FontWriter.setNextUint16(this.idDelta[jj]));
            }
            for (jj = 0; jj < segCount; ++jj) {
                bos.write(FontWriter.setNextUint16(this.idRangeOffset[jj]));
            }
            if (this.glyphIdArray == null) continue;
            for (int aGlyphIdArray : this.glyphIdArray) {
                bos.write(FontWriter.setNextUint16(aGlyphIdArray));
            }
        }
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    @Override
    public int getIntValue(int key) {
        int value = 0;
        switch (key) {
            case 0: {
                value = this.minCharCode;
                break;
            }
            case 1: {
                value = this.maxCharCode;
            }
        }
        return value;
    }

    private int getAdjustedUniValue(String str) {
        if (str.length() == 1) {
            return str.charAt(0);
        }
        if (str.equals("ff")) {
            return 64256;
        }
        if (str.equals("fi")) {
            return 64257;
        }
        if (str.equals("fl")) {
            return 64258;
        }
        if (str.equals("ffi")) {
            return 64259;
        }
        if (str.equals("ffl")) {
            return 64260;
        }
        return -1;
    }

    public int getMaxCharCode() {
        return this.maxCharCode;
    }
}

